<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Encuesta;
use App\Models\Pregunta;
use App\Models\Respuesta;
use App\Models\Opcion;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithDrawings;
 use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithEvents;
/*use Maatwebsite\Excel\Concerns\WithStyles; */

class EncuestaExport implements FromCollection, WithDrawings, WithEvents
{
    private $id;
    public function __construct($id)
        {
            $this->id = $id;
        }

    protected $imagenes = [];
    protected $rowHeights = [];

    public function collection()
    {
        // Asegúrate de usar $this->id para acceder al ID pasado al constructor
        $encuesta = Encuesta::findOrFail($this->id);
        $preguntas = Pregunta::where('encuesta_id', $this->id)->get(); // Usa $this->id también aquí

        $respuestas = Respuesta::where('encuesta_id', $this->id)
        ->with(['usuario', 'meta']) // Relación con meta (respuesta_meta)
        ->orderBy('created_at')
        ->get()
        ->groupBy('respuesta_meta_id');

        $data = collect();

        // Encabezado
        $header = [];
        foreach ($preguntas as $pregunta) {
            $header[] = $pregunta->texto;
        }
        $header[] = 'Fecha';
        $header[] = 'Puntaje';
        $data->push($header);

        // Respuestas
        $row = 2; // donde comienzan los datos después de encabezados (ajustar si cambias arriba)

        foreach ($respuestas as $grupoRespuestas) {
        $fila = [];
        $colIndex = 0;
        $totalPuntaje = 0;
        $conteoPuntaje = 0;


        foreach ($preguntas as $pregunta) {
            $respuestasPregunta = $grupoRespuestas->where('pregunta_id', $pregunta->id);
            if (
                $pregunta->tipo !== 'datos_personales' &&
                $pregunta->tipo !== 'fecha' &&
                $respuestasPregunta->isNotEmpty()
            ) {
                if ($pregunta->tipo === 'seleccion_multiple') {
                    $puntajePregunta = 0;
                    foreach ($respuestasPregunta as $respuesta) {
                        if (is_numeric($respuesta->puntaje)) {
                            $puntajePregunta += $respuesta->puntaje;
                        }
                    }
                    if ($puntajePregunta > 0) {
                        $totalPuntaje += $puntajePregunta;
                        $conteoPuntaje++;
                    }
                } else {
                    // Para preguntas normales (una sola respuesta)
                    $respuesta = $respuestasPregunta->first();
                    if (is_numeric($respuesta->puntaje)) {
                        $totalPuntaje += $respuesta->puntaje;
                        $conteoPuntaje++;
                    }
                }
            }


            if ($respuestasPregunta->isEmpty()) {
                $fila[] = '-';
            } else {
                switch ($pregunta->tipo) {
                    case 'texto':
                    case 'datos_personales':
                    case 'fecha':
                        // ✅ Todos estos almacenan datos en respuesta_texto
                        $fila[] = $respuestasPregunta->first()->respuesta_texto ?? '-';
                        break;
                    case 'texto':
                        $fila[] = $respuestasPregunta->first()->respuesta_texto ?? '-';
                        break;

                    case 'imagen':
                        $respuesta = $respuestasPregunta->first();
                        if ($respuesta->url) {
                            $this->imagenes[] = [
                                'url' => $respuesta->url,
                                'row' => $row,
                                'column' => $colIndex,
                            ];
                            $fila[] = '';
                        } else {
                            $fila[] = '-';
                        }
                        break;

                    case 'opcion':
                        $respuesta = $respuestasPregunta->first();
                        if ($respuesta->opcion_id) {
                            // Si tiene texto personalizado (ej: opción "Otro"), se muestra eso
                            if (!empty($respuesta->respuesta_texto)) {
                                $fila[] = $respuesta->respuesta_texto;
                            } else {
                                $opcion = Opcion::find($respuesta->opcion_id);
                                $fila[] = $opcion ? $opcion->texto : 'Sin texto';
                            }
                        } else {
                            $fila[] = '-';
                        }
                        break;

                    case 'seleccion_multiple':
                        $opcionesTextos = [];
                        foreach ($respuestasPregunta as $respuesta) {
                            if ($respuesta->opcion_id) {
                                // Si tiene texto personalizado (ej: opción "Otro"), se muestra eso
                                if (!empty($respuesta->respuesta_texto)) {
                                    $opcionesTextos[] = $respuesta->respuesta_texto;
                                } else {
                                    $opcion = Opcion::find($respuesta->opcion_id);
                                    if ($opcion) {
                                        $opcionesTextos[] = $opcion->texto;
                                    }
                                }
                            }
                        }
                        $fila[] = implode(', ', $opcionesTextos);
                        break;

                    default:
                        $fila[] = '-';
                }
            }

            $colIndex++;
        }

        $fila[] = $grupoRespuestas->first()->created_at->format('Y-m-d H:i');
        $promedio = round($totalPuntaje / max($conteoPuntaje, 1));
        $fila[] = $promedio;
        $data->push($fila);
        $row++;
    }

    return $data;
}

    public function drawings()
    {
        $drawings = [];

            foreach ($this->imagenes as $imagen) {
                    $url = ltrim($imagen['url'], '/');
                    $imageContent = @file_get_contents($imagen['url']);

                   
                        $tempPath = storage_path('app/public/imagesRespuesta' . uniqid() . '.png');
                        file_put_contents($tempPath, $imageContent);

                        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
                        $drawing->setName('Imagen');
                        $drawing->setDescription('Imagen de respuesta');
                        $drawing->setPath($tempPath);
                        $drawing->setHeight(100);

                        // Calcular coordenadas (A, B, C, ...)
                        $columnLetter = chr(65 + $imagen['column']); // A = 65
                        $drawing->setCoordinates($columnLetter . $imagen['row']);

                        // Centrado horizontal y vertical (ajustando offset manualmente)
                        $drawing->setOffsetX(10); // Horizontal centering (depende del tamaño de columna)
                        $drawing->setOffsetY(10); // Vertical centering (puede ajustarse)

                        $this->rowHeights[$imagen['row']] = max($this->rowHeights[$imagen['row']] ?? 0, 100);
                        $drawings[] = $drawing;
                    
                
            }

        return $drawings;
    }
    
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                foreach ($this->rowHeights as $row => $height) {
                    $sheet->getRowDimension($row)->setRowHeight($height);
                }
            },
        ];
        
    }

        
    }
