<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use App\Models\User;
use App\Models\report;
use Maatwebsite\Excel\Concerns\FromView;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Illuminate\Support\Carbon;


class MasivoExport implements FromView, WithEvents, WithStyles
{
    private $fechaSeleccionada2;
    private $fechaSeleccionada3;


    public function __construct($fechaSeleccionada2, $fechaSeleccionada3)
    {
        $this->fechaSeleccionada2 = $fechaSeleccionada2;
        $this->fechaSeleccionada3 = $fechaSeleccionada3;

    }

    public function view(): View
    {
        $users = User::all();

        /* $carbonFechaSeleccionada2 = Carbon::parse($this->fechaSeleccionada2);
        $mes = $carbonFechaSeleccionada2->month;
        $año = $carbonFechaSeleccionada2->year; */

        $fechaSeleccionada2 = Carbon::parse($this->fechaSeleccionada2);
        $fechaSeleccionada3 = Carbon::parse($this->fechaSeleccionada3);

        $reports = Report::where('state', 'finalizado')
            ->whereBetween('date', [$fechaSeleccionada2, $fechaSeleccionada3])
            ->orderBy('date')
            ->get();

        $reports->load('user');

        return view('masivosheet', [
            'users' => $users,
            'reports' => $reports,
            'fechaSeleccionada2' => $this->fechaSeleccionada2,
            'fechaSeleccionada3' => $this->fechaSeleccionada3
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Ajustar el tamaño de las columnas
                $sheet->getColumnDimension('A')->setWidth(5);
                $sheet->getColumnDimension('B')->setWidth(30);
                $sheet->getColumnDimension('C')->setWidth(40);
                $sheet->getColumnDimension('D')->setWidth(60);
                $sheet->getColumnDimension('E')->setWidth(25);
                $sheet->getColumnDimension('F')->setWidth(20);
                $sheet->getColumnDimension('G')->setWidth(25);
                $sheet->getColumnDimension('H')->setWidth(20);
                $sheet->getColumnDimension('I')->setWidth(25);
                $sheet->getColumnDimension('J')->setWidth(35);
                $sheet->getColumnDimension('K')->setWidth(60);
                $sheet->getColumnDimension('L')->setWidth(60);
                $sheet->getColumnDimension('M')->setWidth(25);
                $sheet->getColumnDimension('N')->setWidth(35);
                $sheet->getColumnDimension('O')->setWidth(35);
                $sheet->getColumnDimension('P')->setWidth(35);



                // Aplicar estilos a las celdas
                $sheet->getStyle('A1:P1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
            }
        ];
    }

    public function styles(Worksheet $sheet)
    {
        // Aplicar estilos a las celdas del cuerpo
        $sheet->getStyle('A2:P1000')->applyFromArray([
            'alignment' => [
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
    }
}
