<?php

namespace App\Exports;

use App\Models\report;
use Illuminate\Support\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\Storage;

class PmsExport implements FromCollection, WithMapping, WithCustomStartCell, WithHeadings
{
    private $fechaSeleccionada4;
    private $fechaSeleccionada5;
    private $reports;
    private $contador = 1;

    public function __construct($fechaSeleccionada4, $fechaSeleccionada5)
    {
        $this->fechaSeleccionada4 = Carbon::parse($fechaSeleccionada4)->startOfDay();
        $this->fechaSeleccionada5 = Carbon::parse($fechaSeleccionada5)->endOfDay();

        $this->reports = report::with('user')
            ->where('state', 'finalizado')
            ->whereNotNull('ruta_url')
            ->whereBetween('created_at', [$this->fechaSeleccionada4, $this->fechaSeleccionada5])
            ->whereHas('user', function ($q) {
                $q->whereIn('ods', [36, 37, 38]); // aquí mira la columna en users
            })
            ->orderBy('date')
            ->get();
    }

    public function collection()
    {
        return $this->reports;
    }

    public function map($report): array
    {
        return [
            $this->contador++,
            $report->created_at,
            $report->updated_at,
            $report->user->emailecp,
            $report->user->name,
            'i) No ha sido diligenciado previamente por ningun integrante del equipo de la ODS y por tanto no existirá duplicidad de reporte. ii) Cumple con el Alcance descrito en la Guia del PMS y iii) No corresponde a un producto en proceso o sin finalizar;',
            $report->aliado,
            $report->ods ? $report->ods : $report->user->ods,
            $report->id_gestion_predial_del_pms,
            $report->tipo_de_hito_clave_de_control,
            $report->hito_clave_de_control_no_planeado_directriz,
            $report->valoracion_de_resultado,
            $report->justificacion_del_impacto_alto,
            $report->funcionario_solicitante_no_planeado,
            $report->horas_acumuladas_al_cumplimiento_hito,
            $report->hito_clave_de_control_solicitud_servicio,
            $report->servicios_participan_elaboracion_del_hito,
            $report->ruta_url,
        ];
    }

    public function headings(): array
    {
        return []; // No sobrescribir encabezados si ya están en la plantilla
    }

    public function startCell(): string
    {
        return 'A2'; // Comienza desde la segunda fila si la primera tiene encabezados
    }
}
