<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use App\Models\User;
use App\Models\report;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\FromView;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Illuminate\Support\Carbon;


class ProdExport implements FromView, WithEvents, WithStyles
{
    private $fechaSeleccionada;

    public function __construct($fechaSeleccionada)
    {
        $this->fechaSeleccionada = $fechaSeleccionada;
    }

    public function view(): View
    {
        $Userid = Auth::user()->identification;
        $users = User::where('identification', $Userid)->get();
        /* $reports = Report::where('professional', $Userid)
            ->orderBy('date')
            ->get()
            ->groupBy('date'); // Agrupa los reportes por fecha
*/

        $Userid = Auth::user()->identification;
        $users = User::where('identification', $Userid)->get();

        $carbonFechaSeleccionada = Carbon::parse($this->fechaSeleccionada);
        $mes = $carbonFechaSeleccionada->month;
        $año = $carbonFechaSeleccionada->year;

        $reports = Report::where('professional', $Userid)
            ->whereYear('date', $año)
            ->whereMonth('date', $mes)
            ->orderBy('date')
            ->get();


        return view('productsheet', [
            'users' => $users,
            'reports' => $reports,
            'fechaSeleccionada' => $this->fechaSeleccionada
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Ajustar el tamaño de las columnas
                $sheet->getColumnDimension('A')->setWidth(5);
                $sheet->getColumnDimension('B')->setWidth(30);
                $sheet->getColumnDimension('C')->setWidth(40);
                $sheet->getColumnDimension('D')->setWidth(60);
                $sheet->getColumnDimension('E')->setWidth(25);
                $sheet->getColumnDimension('F')->setWidth(20);
                $sheet->getColumnDimension('G')->setWidth(25);
                $sheet->getColumnDimension('H')->setWidth(20);
                $sheet->getColumnDimension('I')->setWidth(25);
                $sheet->getColumnDimension('J')->setWidth(35);
                $sheet->getColumnDimension('K')->setWidth(60);



                // Aplicar estilos a las celdas
                $sheet->getStyle('A1:K1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
            }
        ];
    }

    public function styles(Worksheet $sheet)
    {
        // Aplicar estilos a las celdas del cuerpo
        $sheet->getStyle('A2:K100')->applyFromArray([
            'alignment' => [
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
    }
}
