<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use App\Models\User;
use App\Models\Revision;
use Maatwebsite\Excel\Concerns\FromView;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Illuminate\Support\Carbon;

class RevisionExport implements FromView, WithEvents, WithStyles
{
    private $fechaSeleccionada2;
    private $fechaSeleccionada3;


    public function __construct($fechaSeleccionada2, $fechaSeleccionada3)
    {
        $this->fechaSeleccionada2 = $fechaSeleccionada2;
        $this->fechaSeleccionada3 = $fechaSeleccionada3;
    }

    public function view(): View
    {
        $users = User::all();

        $fechaSeleccionada2 = Carbon::parse($this->fechaSeleccionada2);
        $fechaSeleccionada3 = Carbon::parse($this->fechaSeleccionada3);

        $revision = Revision::whereBetween('fecha_respuesta',[$fechaSeleccionada2, $fechaSeleccionada3])
            ->orderBy('fecha_envio')/* ->with('destinatarioUser')->with('remitenteUser') */
            ->get();


        return view('masivoRevi', [
            'users' => $users,
            'revision' => $revision,
            'fechaSeleccionada2' => $this->fechaSeleccionada2,
            'fechaSeleccionada3' => $this->fechaSeleccionada3
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Ajustar el tamaño de las columnas
                $sheet->getColumnDimension('A')->setWidth(5);
                $sheet->getColumnDimension('B')->setWidth(30);
                $sheet->getColumnDimension('C')->setWidth(40);
                $sheet->getColumnDimension('D')->setWidth(40);
                $sheet->getColumnDimension('E')->setWidth(19);
                $sheet->getColumnDimension('F')->setWidth(19);
                $sheet->getColumnDimension('G')->setWidth(15);
                $sheet->getColumnDimension('H')->setWidth(45);
                $sheet->getColumnDimension('I')->setWidth(40);



                // Aplicar estilos a las celdas
                $sheet->getStyle('A1:I1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '000000'],
                        ],
                    ],
                ]);
            }
        ];
    }

    public function styles(Worksheet $sheet)
    {
        // Aplicar estilos a las celdas del cuerpo
        $sheet->getStyle('A2:I1000')->applyFromArray([
            'alignment' => [
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP,
                'wrapText' => false, // Cambia a true si quieres que el texto se ajuste dentro de la celda
            ],
            'borders' => [
                'allBorders' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => ['argb' => '000000'],
                ],
            ],
        ]);
    }
}
