<?php

namespace App\Exports;

use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithDrawings;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithEvents;
use Illuminate\Support\Facades\Auth;
use App\Models\reportTimeModel;
use App\Models\User;
use Rmunate\Calendar\Colombia;
use App\Models\Approver;


class TimesExport implements FromView, WithDrawings, WithEvents
{


    protected $fechaSeleccionada;
    protected $aprobadorSelect;
    protected $talentoSelect;


    public function __construct($fechaSeleccionada, $aprobadorSelect, $talentoSelect)
    {
        $this->fechaSeleccionada = $fechaSeleccionada;
        $this->aprobadorSelect = $aprobadorSelect;
        $this->talentoSelect = $talentoSelect;
    }

    public function view(): view
    {
        $Userid = Auth::user()->identification;
        $aprobador = Approver::select('name', 'identification', 'charge')
            ->where('identification', $this->aprobadorSelect)
            ->first();
        $talento = User::select('name', 'identification', 'charge')
            ->where('identification', $this->talentoSelect)
            ->first();
        $users = User::where('identification', $Userid)->get();
        $reports = reportTimeModel::where('identification', $Userid)
            ->orderBy('date') // Asegúrate de ordenar por fecha
            ->get()
            ->groupBy('date'); // Agrupa los reportes por fecha
        //$usuariosTalentoHumano = User::where('charge', 'LIKE', '%Talento humano%')->get();
        $aprobadorData = [
            'name' => $aprobador->name,
            'identification' => $aprobador->identification,
            'charge' => $aprobador->charge,
        ];
        $talentoData = [
            'name' => $talento->name,
            'identification' => $talento->identification,
            'charge' => $talento->charge,
        ];
        return view('timesheet', [
            'users' => $users,
            'reports' => $reports,
            'talentoData' => $talentoData,
            'fechaSeleccionada' => $this->fechaSeleccionada,
            'aprobadorData' => $aprobadorData,
        ]);
    }



    public function drawings()
    {
        $drawing = new Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('This is my logo');
        $drawing->setPath(public_path('images/ingicat.png'));
        $drawing->setHeight(75);
        $drawing->setCoordinates('A1');
        return $drawing;
    }

    public  function consulta() {}

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();

                // Aplicar estilo de fuente a todo el contenido
                /* $sheet->getParent()->getDefaultStyle()->applyFromArray([
                    'font' => [
                        'name' => 'Arial',              // Cambia la fuente aquí
                        'size' => 9,                    // Cambia el tamaño de la fuente aquí
                        'bold' => false,                // Define si quieres negrita
                        'color' => ['rgb' => '000000'], // Color del texto en hexadecimal
                    ],
                ]); */
                $highestRow = $sheet->getHighestRow();
                $highestColumn = $sheet->getHighestColumn();

                // Aplicar la fuente a todo el rango
                $sheet->getStyle("A1:{$highestColumn}{$highestRow}")->applyFromArray([
                    'font' => [
                        'name' => 'Arial',  // Cambia la fuente aquí
                        'size' => 9,       // Cambia el tamaño de la fuente aquí
                        'bold' => false,    // Define si quieres negrita
                          // Color del texto en hexadecimal
                    ],
                ]);

                // Ajustar el tamaño de las columnas
                $sheet->getColumnDimension('A')->setWidth(5);
                $sheet->getColumnDimension('B')->setWidth(15);
                $sheet->getColumnDimension('C')->setWidth(8);
                $sheet->getColumnDimension('D')->setWidth(8);
                $sheet->getColumnDimension('E')->setWidth(8);
                $sheet->getColumnDimension('F')->setWidth(8);
                $sheet->getColumnDimension('G')->setWidth(8);
                $sheet->getColumnDimension('H')->setWidth(10);
                $sheet->getColumnDimension('I')->setWidth(10);
                $sheet->getColumnDimension('J')->setWidth(10);

                // Ajustar la altura de las filas automáticamente para que se muestre todo el contenido
                foreach ($sheet->getRowIterator() as $row) {
                    $sheet->getRowDimension($row->getRowIndex())->setRowHeight(-1);
                }
            }
        ];
    }
}
