<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Charge;
use Illuminate\Http\Request;

class AgregarProductoController extends Controller
{
    public function index(Request $request)
    {
        $perfiles = Charge::all();
        $productos = Category::Produ($request->BuscarPerfil)->paginate(6);

        if ($request->ajax()) {
            return view('partials.tableProductos', compact('productos'))->render();
        }

        return view('agregarProducto', compact('perfiles', 'productos'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'perfil' => 'required|string',
            'producto' => 'required|string',
            'categoria' => 'required|string',
        ]);

        $nuevoProducto = Category::create([
            'sector' => $request->perfil,
            'product' => $request->producto,
            'category' => $request->categoria
        ]);

        if ($nuevoProducto) {
            return response()->json(['success' => 'Producto agregado exitosamente.']);
        }

        return response()->json(['success'  => false, 'message' => 'El producto no pudo registrarse de forma correcta.'], 404);
    }

    public function destroy($id)
    {

        // Busca el producto por el id
        $selectProducoId = Category::where('id', $id)->first();

        // Si el usuario existe, lo elimina de la base de datos
        if ($selectProducoId) {
            $selectProducoId->delete();
            // Retorna una respuesta en JSON indicando el éxito de la operación
            return response()->json(['success' => 'Eliminación de producto exitoso']);
        }

        // Si el usuario no se encuentra, retorna un error 404
        return response()->json(['error' => 'Producto no encontrado'], 404);
    }
}
