<?php

namespace App\Http\Controllers;

use App\Imports\importFn;
use App\Models\New_fn;
use App\Models\Service;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\User;
use Illuminate\Http\Request;

class AsignacionFnController extends Controller
{
    public function index(Request $request)
    {

        $fn_asignados = New_fn::join('users', 'new_fn.identification', '=', 'users.identification')
            ->select('new_fn.*', 'users.name as professional_name')
            ->search($request->scope)
            ->paginate(6);

        $usuarios = User::all();

        // Obtiene todos los servicios disponibles
        $servicios = Service::all();

        if ($request->ajax()) {
            return view('partials.table', compact('fn_asignados'))->render();
        }

        return view('asignacionFn', compact('usuarios', 'fn_asignados', 'servicios'));
    }

    public function new(Request $request)
    {
        $request->validate([
            'fn' => 'required|string',
            'professional' => 'required|integer',
            'service' => 'required|string',

        ]);


        $existingFn = New_fn::where('fn', $request->fn)
            ->where('identification', $request->professional)
            ->first();

        // Si la combinación ya existe, devolver un error
        if ($existingFn) {
            return response()->json(['error' => 'Ya existe un registro con esta FN y este profesional'], 400);
        }


        New_fn::create([
            'fn' => $request->fn,
            'identification' => $request->professional,
            'service' => $request->service,
        ]);

        return response()->json(['success' => 'Fn asignado']);
    }

    public function import(Request $request)
    {
        $file = $request->file('document_csv');
        Excel::import(new importFn, $file);
        // return redirect()->route('index');
        return response()->json(['success' => 'Importación realizada con exíto']);
    }

    public function destroyFn($identification, $fn)
    {

        // Busca al usuario por su identificación y su fn
        $fnasignado = New_fn::where('identification', $identification)
            ->where('fn', $fn)
            ->first();

        // Si el usuario existe, lo elimina de la base de datos
        if ($fnasignado) {
            $fnasignado->delete();
            // Retorna una respuesta en JSON indicando el éxito de la operación
            return response()->json(['success' => 'Eliminación Fn asignado exitoso']);
        }

        // Si el usuario no se encuentra, retorna un error 404
        return response()->json(['error' => 'Fn asignado no encontrado'], 404);
    }
}
