<?php

namespace App\Http\Controllers;

use App\Imports\importSig;
use App\Models\Codigo_sig;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class CodigoSigController extends Controller
{
    public function index(Request $request)
    {
        $sigs = Codigo_sig::Fnsig($request->FnBuscar)->paginate(6);

        if ($request->ajax()) {
            return view('partials.tableSig', compact('sigs'))->render();
        }

        return view('fn_codigo', compact('sigs'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'fn' => 'required|string',
            'codigo' => 'required|string'
        ]);

        $fns = Codigo_sig::create([
            'fn' => $request->fn,
            'codigo_sig' => $request->codigo
        ]);

        if ($fns) {
            return response()->json(['success' => 'registrado correctamente']);
        }

        return response()->json(['success'  => false, 'message' => 'No se pudo realizar la operación, favor intentar mas tarde.'], 404);
    }

    public function import(Request $request)
    {
        $file = $request->file('fn_sig');
        Excel::import(new importSig, $file);
        // return redirect()->route('index');
        return response()->json(['success' => 'Importación realizada con exíto']);
    }

    public function destroy($id){
        $sigSelect = Codigo_sig::where('id', $id)->first();

        if ($sigSelect) {
            $sigSelect->delete();

            return response()->json(['success' => 'Elminación Fn y Sig realizado con exito']);
        }
        return response()->json(['error' => 'Error al importar datos, fn o codigo sig duplicados.'], 404);
    }
}
