<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth; // Importa el sistema de autenticación de Laravel
use Illuminate\Support\Facades\Hash; // Facilita el hashing de contraseñas
use App\Models\User; // Importa el modelo User

class ConfigurarController extends Controller
{
    //
    public function index()
    {
        return view('setting');
    }

    // Maneja la solicitud para cambiar la contraseña del usuario
    public function save(Request $request)
    {
        // Valida los campos de la solicitud
        $request->validate([
            'current_password' => 'required', // La contraseña actual es obligatoria
            'new_password' => 'required|min:8|confirmed', // La nueva contraseña es obligatoria, debe tener al menos 8 caracteres y coincidir con la confirmación
        ]);

        // Obtiene el usuario autenticado
        $user = User::find(Auth::id());

        // Verifica si la contraseña actual proporcionada coincide con la contraseña almacenada
        if (!Hash::check($request->current_password, $user->password)) {
            // Si no coincide, retorna un mensaje de error en formato JSON
            return response()->json(['error'  => 'La contraseña actual no es correcta.']);
        }

        // Si la contraseña actual es correcta, se procede a actualizar la contraseña con la nueva
        $user->password = Hash::make($request->new_password); // Encripta la nueva contraseña antes de guardarla


        try {
            // Intenta guardar el nuevo valor en la base de datos
            $user->save();
            // Si todo va bien, retorna un mensaje de éxito en formato JSON
            return response()->json(['success' => 'Contraseña cambiada correctamente.']);
        } catch (\Exception $e) {
            // Si ocurre un error durante la actualización, retorna un mensaje de error en formato JSON
            return response()->json(['error' => 'Error al actualizar la contraseña.']);
        }
    }

    public function actualizarDatos(Request $request)
    {
        /** @var \App\Models\User $user */
        $user = Auth::user();

        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $user->id,
            'phone' => 'nullable|string|max:20',
            'location' => 'required|string|max:100',
            'emailecp' => 'nullable|email|max:150',
        ]);

        $user->update([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'location' => $request->location,
            'emailecp' => $request->emailecp,
        ]);

        return response()->json(['success' => true, 'message' => 'Datos actualizados correctamente.']);
    }
}
