<?php

namespace App\Http\Controllers;

use App\Exports\DescarExport;
use App\Exports\MasivoExport;
use App\Exports\PmsExport;
use App\Models\User;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class DescargaController extends Controller
{
    public function index()
    {
        return view('descargas');
    }

    // Método para exportar los reportes a un archivo Excel
    public function export(Request $request)
    {
        // Obtiene la fecha seleccionada desde el formulario de la vista
        $fechaSeleccionada = $request->input('fecha');
        $documentoSeleccionado = $request->input('buscar');

        $usuario  = User::where('identification', $documentoSeleccionado)->select('name')->first();

        if (!$usuario) {
            // return response()->json(['success'  => false, 'message' => 'No se pudo realizar la operación, favor intentar mas tarde.'], 404);
            return redirect()->back()->withErrors(['message' => 'El usuario no está registrado.']);
        }

        $nombreArchivo = $usuario ? $usuario->name : 'Usuario';

        // Utiliza la clase ProdExport para generar y descargar el archivo Excel con los reportes de la fecha seleccionada
        return Excel::download(new DescarExport($fechaSeleccionada, $documentoSeleccionado), "Reporte-Producto-{$nombreArchivo}.xlsx");
    }

    public function masivo(Request $request)
    {
        // Obtiene la fecha seleccionada desde el formulario de la vista
        $fechaSeleccionada2 = $request->input('fecha2');
        $fechaSeleccionada3 = $request->input('fecha3');

        // Utiliza la clase ProdExport para generar y descargar el archivo Excel con los reportes de la fecha seleccionada
        return Excel::download(new MasivoExport($fechaSeleccionada2, $fechaSeleccionada3), 'Reporte-Producto-Masivo.xlsx');
    }

    public function pms(Request $request)
    {
        $fechaSeleccionada4 = $request->input('fecha4');
        $fechaSeleccionada5 = $request->input('fecha5');

        $export = new \App\Exports\PmsExport($fechaSeleccionada4, $fechaSeleccionada5);
        $filename = 'Reporte-PMS-Masivo.xlsx';

        // Cargar la plantilla
        $templatePath = storage_path('app/templates/PLANTILLA.xlsx');
        $spreadsheet = IOFactory::load($templatePath);
        $sheet = $spreadsheet->getActiveSheet();

        // Llenar con los datos manualmente
        $row = 2;
        foreach ($export->collection() as $report) {
            $mapped = $export->map($report);
            foreach ($mapped as $col => $value) {
                $sheet->setCellValueByColumnAndRow($col + 1, $row, $value);
            }
            $row++;
        }

        $lastRow = $row - 1;
        $highestRow = $sheet->getHighestRow();

        if ($highestRow > $lastRow) {
            $sheet->removeRow($lastRow + 1, $highestRow - $lastRow);
        }

        // Ajustes de visibilidad y área activa
        $sheet->setSelectedCell('A1');


        // Guardar temporalmente
        $tempPath = storage_path("app/temp/$filename");
        $writer = new Xlsx($spreadsheet);
        $writer->save($tempPath);

        return response()->download($tempPath)->deleteFileAfterSend(true);
    }
}
