<?php

namespace App\Http\Controllers;


use App\Models\RespuestaMeta;
use App\Models\Encuesta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Respuesta;

use Illuminate\Support\Facades\storage;

class EncuestaController extends Controller
{
    public function mostrarEncuestasPorCategoria()
    {
        $categorias = ['Actos y condiciones inseguras', 'Conversaciones y reflexiones', 'Momento HSE', 'Campañas', 'Alertas HSE ECP', 'Capacitaciones'];

        $encuestasAgrupadas = [];
        foreach ($categorias as $cat) {
            $encuestasAgrupadas[$cat] = Encuesta::where('categoria', $cat)
                ->where('activa', true)
                ->get();
        }

        return view('hse.inicio', compact('encuestasAgrupadas'));
    }

    public function crear()
    {
        $categorias = ['Actos y condiciones inseguras', 'Conversaciones y reflexiones', 'Momento HSE', 'Campañas', 'Alertas HSE ECP', 'Capacitaciones'];
        return view('hse.crear', compact('categorias'));
    }

    public function guardar(Request $request)
    {
        $request->validate([
                'preguntas' => 'required|array',
            ]);

        // Verificar que al menos una pregunta tenga texto no vacío
        $tieneAlMenosUna = collect($request->preguntas)
            ->filter(fn($p) => !empty($p['texto']))
            ->isNotEmpty();

        if (!$tieneAlMenosUna) {
            return back()
                ->withErrors(['preguntas' => 'Debe ingresar al menos una pregunta con texto.'])
                ->withInput();
        }

        $request->validate([
            'titulo' => 'required|string    ',
            'categoria' => 'required|string',
            'frecuencia' => 'required|string',
            'descripcion' => 'nullable|string',
            'file' => 'nullable|image',
            'activa' => 'boolean',
            'preguntas.*.texto' => 'required|string',
            'preguntas.*.tipo' => 'required|string',
            'preguntas.*.valor' => 'nullable|string',
        ]);

        /* $imagenes= $request->file('file')->store('public/images');
        $url = Storage::url($imagenes); */
        //$url= "null";
        if ($request->hasFile('file')) {
            $imagenes = $request->file('file')->store('public/images');
            $url = Storage::url($imagenes);
        }

        $encuesta = Encuesta::create([
            'titulo' => $request->titulo,
            'descripcion' => $request->descripcion,
            'frecuencia' => $request->frecuencia,
            'url' => !empty($url) ? $url : null,
            //'url' => $url,
            'categoria' => $request->categoria,
            'activa' => $request->has('activa'),
            'creada_por' => Auth::id(),
        ]);

        // Guardar preguntas asociadas
        foreach ($request->preguntas as $index => $preguntaData) {
            $pregunta = $encuesta->preguntas()->create([
                'texto' => $preguntaData['texto'],
                'tipo' => $preguntaData['tipo'],
                'valor' => $preguntaData['valor'],
                'orden' => $index + 1,
                
            ]);

            if (in_array($preguntaData['tipo'], ['opcion', 'seleccion_multiple'])) {
                /*foreach ($preguntaData['opciones'] as $opcionTexto) {
                    $pregunta->opciones()->create([
                        'texto' => $opcionTexto,
                        'valor' => $opcionIndex['valor'],
                    ]);
                } */
               foreach ($preguntaData['opciones'] as $opcionData) {
                    $pregunta->opciones()->create([
                        'texto' => $opcionData['texto'],
                        'valor' => $opcionData['valor'],
                    ]);
                }
            }
        }
        if ($request->has('imageAct')) {
            $encuesta->preguntas()->create([
                'texto' => 'Por favor, seleccione la imagen en caso de ser necesario',
                'tipo' => 'imagen', // Asumiendo que tienes un tipo 'imagen' definido
                'orden' => count($request->preguntas) + 1, // Lo colocas al final
            ]);
        }
        //return response()->json(['success' => 'Encuesta Registrada']);
               
        return redirect()->route('hse.crear')->with('success', 'Encuesta creada con éxito.');
    }

    public function verPorCategoria($categoria)
    {
        $encuestas = Encuesta::where('categoria', $categoria)
            ->where('activa', 1)
            ->get();
        return view('hse.encuestas_por_categoria', compact('categoria', 'encuestas'));
    }

    public function responder($id)
    {
        $encuesta = Encuesta::with('preguntas.opciones')->findOrFail($id);

        $yaRespondida = Respuesta::where('encuesta_id', $id)
            ->where('user_id', Auth::id());

        $bloquear = false;

        switch ($encuesta->frecuencia) {
            case 'única':
                $bloquear = $yaRespondida->exists();
                break;
            case 'mensual':
                $bloquear = $yaRespondida->whereMonth('created_at', now()->month)
                    ->whereYear('created_at', now()->year)
                    ->exists();
                break;
            case 'varias':
                $bloquear = false;
                break;
        }

        if ($bloquear) {
            return redirect()->back()->with('error', 'Ya has respondido esta encuesta según su frecuencia permitida.');
        }

        return view('hse.responder', compact('encuesta'));
    }


    public function guardarRespuestas(Request $request, $id)
    {
        $encuesta = Encuesta::with('preguntas.opciones')->findOrFail($id);

        $yaRespondida = Respuesta::where('encuesta_id', $id)
            ->where('user_id', Auth::id());

        $bloquear = false;

        switch ($encuesta->frecuencia) {
            case 'única':
                $bloquear = $yaRespondida->exists();
                break;
            case 'mensual':
                $bloquear = $yaRespondida->whereMonth('created_at', now()->month)
                    ->whereYear('created_at', now()->year)
                    ->exists();
                break;
            case 'varias':
                $bloquear = false;
                break;
        }

        if ($bloquear) {
            return redirect()->route('hse.ver')->with('error', 'Ya respondiste esta encuesta según su frecuencia permitida.');
        }

        /* $request->validate([
            'file' => 'nullable|image',
        ]); */

        /* $archivo = $request->file('file');
                if ($archivo) {
                    $imagenes = $request->file('file')->store('public/imagesRespuesta');
                    $url = Storage::url($imagenes);

                    $preguntaId = $request->input('pregunta_id');
                    Respuesta::create([
                        'encuesta_id' => $encuesta->id,
                        'pregunta_id' => $preguntaId,
                        'opcion_id' => null,
                        'respuesta_texto' => null,
                        'file' => $url,
                        'user_id' => Auth::id(),
                    ]);
                    return $request->all();
                } */
        
        

        DB::beginTransaction();
        try {
            // 1. Crear el registro en respuesta_meta
            $respuestaMeta = RespuestaMeta::create([
                'encuesta_id' => $encuesta->id,
                'user_id' => Auth::id(),
                'completada' => '1',
                'fecha_respuesta' => now(),
            ]);
//return $request->all();
            foreach ($encuesta->preguntas as $pregunta) {
                $valor = $request->input("respuestas.{$pregunta->id}");

                /* if ($pregunta->tipo === 'seleccion_multiple' && is_array($valor)) {
                    foreach ($valor as $opcionId) {
                        Respuesta::create([
                            'respuesta_meta_id' => $respuestaMeta->id,
                            'encuesta_id' => $encuesta->id,
                            'pregunta_id' => $pregunta->id,
                            'opcion_id' => $opcionId,
                            'user_id' => Auth::id(),
                        ]);
                    }
                } */
                if ($pregunta->tipo === 'seleccion_multiple' && is_array($valor)) {
                foreach ($valor as $opcionId) {
                        // Verificar si esta opción es "Otro"
                        $opcion = $pregunta->opciones->firstWhere('id', $opcionId);
                        //$DatoValor = $pregunta->opciones->firstWhere('id', $opcionId);
                        $esOtro = strtolower($opcion->texto) === 'otro';

                        Respuesta::create([
                            'respuesta_meta_id' => $respuestaMeta->id,
                            'encuesta_id' => $encuesta->id,
                            'pregunta_id' => $pregunta->id,
                            'opcion_id' => $opcionId,
                            'respuesta_texto' => $esOtro ? $request->input("respuestas_otro.{$pregunta->id}") : null,
                            'puntaje' => $opcion->valor,
                            'user_id' => Auth::id(),
                        ]);
                        
                    }
                }

                // 2. PREGUNTA DE OPCIÓN ÚNICA (RADIO)
                else if ($pregunta->tipo === 'opcion') {
                    $opcionId = $valor;
                    $opcion = $pregunta->opciones->firstWhere('id', $opcionId);
                    $esOtro = strtolower($opcion->texto) === 'otro';

                    Respuesta::create([
                        'respuesta_meta_id' => $respuestaMeta->id,
                        'encuesta_id' => $encuesta->id,
                        'pregunta_id' => $pregunta->id,
                        'opcion_id' => $opcionId,
                        'respuesta_texto' => $esOtro ? $request->input("respuestas_otro.{$pregunta->id}") : null,
                        'puntaje' => $opcion->valor,
                        'user_id' => Auth::id(),
                    ]);
                }
                else if($pregunta->tipo === 'imagen'){
                            $imagenes = $request->file('file')->store('public/imagesRespuesta');
                            /* $url = Storage::url($imagenes); */
                            $url = ltrim(Storage::url($imagenes), '/');
                            Respuesta::create([
                                'respuesta_meta_id' => $respuestaMeta->id,
                                'encuesta_id' => $encuesta->id,
                                'pregunta_id' => $pregunta->id,
                                'url' => $url,
                                'user_id' => Auth::id(),
                            ]);
                        }
                else if($pregunta->tipo === 'datos_personales'){
                            Respuesta::create([
                                'respuesta_meta_id' => $respuestaMeta->id,
                                'encuesta_id' => $encuesta->id,
                                'pregunta_id' => $pregunta->id,
                                'respuesta_texto' =>  $valor ,
                                'puntaje' => $pregunta->valor,
                                'user_id' => Auth::id(),
                            ]);
                }
                else if ($pregunta->tipo === 'fecha') {
                            Respuesta::create([
                                'respuesta_meta_id' => $respuestaMeta->id,
                                'encuesta_id' => $encuesta->id,
                                'pregunta_id' => $pregunta->id,
                                'respuesta_texto' => $valor,
                                'puntaje' => $pregunta->valor,
                                'user_id' => Auth::id(),
                            ]);
                        }
                else {
                    Respuesta::create([
                        'respuesta_meta_id' => $respuestaMeta->id,
                        'encuesta_id' => $encuesta->id,
                        'pregunta_id' => $pregunta->id,
                        'opcion_id' => $pregunta->tipo !== 'texto' ? $valor : null,
                        'respuesta_texto' => $pregunta->tipo === 'texto' ? $valor : null,
                        'puntaje' => $pregunta->valor,
                        'user_id' => Auth::id(),
                    ]);
                }
            }

            //return $request->all();
            DB::commit();
            return redirect()->route('hse.ver')->with('success', 'Respuestas enviadas con éxito.');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->with('error', 'Error al guardar las respuestas.');
        }
    }
    
}
