<?php

namespace App\Http\Controllers;

use App\Mail\RevisionMailable;
use App\Models\Category;
use App\Models\Revision;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class EnviarController extends Controller
{
    public function index(Request $request)
    {
        $yo = Auth::user()->identification;
        $cargos = Auth::user()->charge;

        $usuarios = User::all();

        // $miLista = Revision::where('remitente', $yo)->paginate(5);
        $miLista = Revision::with('destinatarioUser') // Cambiar aquí
            ->where('remitente', $yo)
            ->orderBy('fecha_envio', 'desc')
            ->paginate(5);

        $productos = Category::where('sector', $cargos)->select('product')->orderBy('product', 'asc')->get();

        if ($request->ajax()) {
            return view('partials.tableRevision', compact('miLista'))->render();
        }

        return view('enviar', compact('miLista', 'productos'));
    }

    public function enviar(Request $request)
    {
        $request->validate([
            'titulo' => 'required|string',
            'descripcion' => 'nullable|string',
            'link' => 'required|string',
        ]);

        $idRemitente = Auth::user()->identification;
        $remitente = User::where('identification', $idRemitente)->first();

        //Cargo del remitente
        $cargoRemitente = $remitente->charge;

        //selecciona un usuario con el mismo cargo del remitente, excluyendo almmismo remitente para evitar envios al mismo usuraio
        $destinatarios = User::where('charge', $cargoRemitente)
            ->where('identification', '!=', $remitente->identification)
            ->where('state', 'Activo')
            ->get();

        //verificamos si hay destinatarios disponibles
        if ($destinatarios->isEmpty()) {
            return response()->json(['success'  => false, 'message' => 'No hay destinatarios disponibles.'], 404);
        }

        //elegir un destinatrio al azar
        $destinatario = $destinatarios->random();

        $titulo = $request->titulo;
        $descripcion = $request->descripcion;
        $link = $request->link;

        //enviar correo
        Mail::to($destinatario->email)->send(new RevisionMailable($remitente->name, $destinatario->name, $titulo, $descripcion, $link));


        Revision::create([
            'remitente' => $idRemitente,
            'destinatario' => $destinatario->identification,
            'titulo' => $request->titulo,
            'fecha_envio' => now(),
            'link' => $request->link
        ]);

        return response()->json(['success' => 'Mensaje enviado correctamente a ' . $destinatario->name]);
    }
}
