<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Report;
use App\Models\reportTimeModel;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class ListaController extends Controller
{
    //
    public function lista(request $request)
    {
        $UserId = Auth::user()->identification;

        $filterDate = $request->input('filterDate');
        $year = date('Y', strtotime($filterDate)); // Extraer el año
        $month = date('m', strtotime($filterDate)); // Extraer el mes

        $reportes = Report::where('professional', $UserId)
                        ->whereYear('date', $year)
                        ->whereMonth('date', $month)
                        ->whereNotNull('link')
                        ->orderBy('date')
                        ->get();

        return view('lista', compact('reportes'));
    }

    public function edicion($id)
    {
        // Busca el reporte por su ID y lo retorna como JSON
        $report = Report::findOrFail($id);
        return response()->json($report);
    }

    public function actualizacion(Request $request, $id)
    {
        $request->validate([
            'fecha' => 'required|date',
            'fn' => 'required|string',
            'codigoSIG' => 'required|string',
            'categoria' => 'required|string',
            'descripcion' => 'required|string',
        ]);

        $report = Report::findOrFail($id);

        $report->update([
            'date' => $request->fecha,
            'fn' => $request->fn, // Asegúrate de que el nombre del campo coincide
            'code_sig' => $request->codigoSIG,
            'category' => $request->categoria,
            'link' => $request->link,
            'description' => $request->descripcion,
        ]);

        return response()->json(['success' => 'Actualizacion de datos registrada exitosamente']);
    }

    public function dell(Request $request, $id)
    {
        $report = Report::findOrFail($id);
        if ($report) {
            reportTimeModel::where('id_report', $id)->delete();
            $report->delete();

            // Retorna una respuesta en JSON indicando el éxito de la operación
            return response()->json(['success' => 'Reporte eliminado con éxito']);
        }
        // Si el usuario no se encuentra, retorna un error 404
        return response()->json(['error' => 'Usuario no encontrado'], 404);
    }
}
