<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request; // Importa la clase Request para manejar las solicitudes HTTP
use Maatwebsite\Excel\Facades\Excel; // Facilita la exportación de datos a Excel
use App\Exports\ProdExport; // Clase que gestiona la exportación de datos
use App\Models\User; // Importa el modelo User
use App\Models\report; // Importa el modelo report
use Illuminate\Support\Facades\Auth; // Importa el sistema de autenticación de Laravel
use Illuminate\Support\Carbon; // Manejo de fechas y tiempos

class ProdExportController extends Controller
{
    // Método para mostrar la vista principal de exportación
    public function index()
    {
        // Obtiene la identificación del usuario autenticado
        $Userid = Auth::user()->identification;

        // Busca al usuario actual en la base de datos utilizando su identificación
        $users = User::where('identification', $Userid)->get();

        // Busca los reportes asociados al usuario actual, los ordena por fecha y los agrupa por fecha
        $reports = Report::where('professional', $Userid)
            ->orderBy('date')
            ->get()
            ->groupBy('date'); // Agrupa los reportes por fecha
    }

    // Método para exportar los reportes a un archivo Excel
    public function export(Request $request)
    {
        // Obtiene la fecha seleccionada desde el formulario de la vista
        $fechaSeleccionada = $request->input('fechaReporte');

        // Utiliza la clase ProdExport para generar y descargar el archivo Excel con los reportes de la fecha seleccionada
        return Excel::download(new ProdExport($fechaSeleccionada), 'Reporte-Producto.xlsx');
    }
}
