<?php

namespace App\Http\Controllers;

use App\Mail\RecepcionMailable;
use App\Models\Revision;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class RecepcionController extends Controller
{
    public function index(Request $request)
    {

        $yo = Auth::user()->identification;

        $recepciones = Revision::with('destinatarioUser')->with('remitenteUser')
            ->where('destinatario', $yo)
            ->where('fecha_respuesta', null)
            ->orderBy('fecha_envio', 'desc')
            ->paginate(5);

        // $recepciones = Revision::where('destinatario', $yo)->paginate(5);

        if ($request->ajax()) {
            return view('partials.tableRecepcion', compact('recepciones'))->render();
        }

        return view('recepcion', compact('recepciones'));
    }

    public function update(Request $request, $id)
    {
        //validación de los datos ingresados
        $request->validate([
            'errores' => 'required|integer',
            'observaciones' => 'required|string',
        ]);

        //Buscar la revision correspondiente
        $recepcion = Revision::findOrFail($id);

        //obterner el remitente
        $reenvioRemitente = User::where('identification', $recepcion->remitente)->first();

        //verificamos que el remitente tenga un correo electronico
        $correoRemi = $reenvioRemitente->email;

        if (!$correoRemi) {
            return response()->json(['error' => 'El remitente no tiene un correo electrónico válido.'], 400);
        }

        // Preparar los datos para el correo
        $nombreRemi = $reenvioRemitente->name;
        $nombreDesti = Auth::user()->name; // Nombre del destinatario (usuario autenticado)
        $titulo = $recepcion->titulo;
        $errores = $request->errores;
        $observaciones = $request->observaciones;
        $linkProducto = $recepcion->link;

        //enviar correo
        Mail::to($correoRemi)->send(new RecepcionMailable($nombreRemi, $nombreDesti, $titulo, $errores, $observaciones, $linkProducto));

        //actualizar la recepcion con la fecha de respuesta y los detalles ingresados en el formulario
        $recepcion->update([
            'fecha_respuesta' => now(),
            'n_errores' => $request->errores,
            'observaciones' => $request->observaciones
        ]);

        return response()->json(['success' => 'Respuesta enviada correctamente a ' . $nombreRemi]);
    }
}
