<?php

namespace App\Http\Controllers;

use App\Mail\ContactanosMailable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Models\User;

class RecuperarController extends Controller
{
    public function index()
    {
        return view('auth.recuperar');
    }

    public function enviarCorreo(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users,email',
        ]);

        $newPassword = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 9);

        $user = User::where('email', $request->email)->first();

        $user->password = Hash::make($newPassword);
        $user->save();

        $correo = new ContactanosMailable($newPassword);
        Mail::to($request->email)->send($correo);

        // Redireccionar al formulario de login con un mensaje de éxito
        return redirect()->route('login')->with('status', 'Se ha enviado una nueva contraseña a su correo electrónico.');
    }
}
