<?php

namespace App\Http\Controllers;

use App\Models\Approver;
use App\Models\Charge;
use Illuminate\Http\Request;

class RegistrosController extends Controller
{
    public function index(Request $request)
    {
        //se obtienen los cargos asignar


        $cargos = Charge::all();
        $aprobadores = Approver::paginate(5);

        if ($request->ajax()) {
            return view('partials.tablaAprbador', compact('aprobadores'))->render();
        }
        return view('registros', compact('cargos', 'aprobadores'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'identification' => 'required|integer|unique:approvers,identification',
            'name' => 'required|string',
            'charge' => 'required|string',
        ]);

        Approver::create([
            'identification' => $request->identification,
            'name' => $request->name,
            'charge' => $request->charge,
        ]);

        return response()->json(['success' => 'Aprobador registrado']);
    }

    public function destroy($identification)
    {
        // Busca al usuario por su identificación
        $approver = Approver::where('identification', $identification)->first();

        // Si el usuario existe, lo elimina de la base de datos
        if ($approver) {
            $approver->delete();
            // Retorna una respuesta en JSON indicando el éxito de la operación
            return response()->json(['success' => 'Aprobador eliminado con éxito']);
        }

        // Si el usuario no se encuentra, retorna un error 404
        return response()->json(['error' => 'Aprobador no encontrado'], 404);
    }
}
