<?php

namespace App\Http\Controllers;

use App\Exports\TimesExport; // Clase que gestiona la exportación de datos a Excel
use Maatwebsite\Excel\Facades\Excel; // Facilita la exportación de datos a Excel
use App\Models\reportTimeModel; // Modelo que gestiona los registros de tiempo de los reportes
use App\Models\User; // Modelo que gestiona los usuarios
use Illuminate\Http\Request; // Manejo de solicitudes HTTP
use Illuminate\Support\Facades\Auth; // Proporciona funcionalidad de autenticación
use Carbon\Carbon; // Biblioteca para manejo de fechas y tiempo
use Rmunate\Calendar\Colombia;

class TimesController extends Controller
{
    // Muestra la vista principal con los registros de tiempo del usuario
    public function index()
    {
        // Obtiene la identificación del usuario autenticado
        $Userid = Auth::user()->identification;

        // Busca al usuario actual en la base de datos usando su identificación
        $users = User::where('identification', $Userid)->get();

        // Obtiene los registros de tiempo asociados al usuario, ordenados por fecha y agrupados por fecha
        $reports = reportTimeModel::where('identification', $Userid)
            ->orderBy('date') // Asegúrate de ordenar por fecha
            ->get()
            ->groupBy('date'); // Agrupa los reportes por fecha



        // Retorna la vista 'timesheet' con los datos de usuarios y reportes
        return view('timesheet', compact('users', 'reports'));
    }

    // Exporta los registros de tiempo a un archivo Excel
    public function export(Request $request)
    {
        // Obtiene la fecha seleccionada desde la solicitud HTTP
        $fechaSeleccionada = $request->input('fecha');
        $aprobadorSelect = $request->input('aprobador');
        $talentoSelect = $request->input('talento');
        // Utiliza la clase TimesExport para generar y descargar el archivo Excel con los registros de la fecha seleccionada
        return Excel::download(new TimesExport($fechaSeleccionada, $aprobadorSelect, $talentoSelect), 'Reporte-Tiempo.xlsx');
    }
}
