<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Encuesta;
use App\Models\Pregunta;
use App\Models\Respuesta;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\EncuestaExport;
use App\Exports\EncuestaIndividualExport;
use App\Exports\EncuestaPeriodoExport;

class adminEncuestaController extends Controller
{
    //
    public function index(Request $request)
    {
        $busqueda = $request->input('EncuestaBus');
        $encuestas = Encuesta::encuesta($busqueda)
        ->paginate(10)
        ->appends(['EncuestaBus' => $busqueda]); // Para mantener el valor en la paginación

    return view('hse.adminEncuesta', compact('encuestas', 'busqueda'));
    }

    
   public function cambiarEstado(Request $request, $id)
    {
        $encuesta = Encuesta::findOrFail($id);
        $nuevoEstado = $request->input('state');

        $encuesta->activa = $nuevoEstado;
        $encuesta->save();

        return response()->json([
            'success' => true,
            'new_state' => $encuesta->activa
        ]);
    }
    public function eliminar(Request $request, $id)
    {
        $encuesta = Encuesta::findOrFail($id);
        $encuesta->delete();

        return response()->json([
            'success' => true,
            'message' => 'Encuesta eliminada correctamente'
        ]);
    }
    public function individual(Request $request, $id)
    {
        $documento = $request->input('documento');
        return Excel::download(new EncuestaIndividualExport($id, $documento), 'Encuesta_' . $id . '_'. $documento .'.xlsx');
    }
    
    public function masivo($id)
    {
        return Excel::download(new EncuestaExport($id), 'Encuesta_' . $id . '.xlsx');
    }

    public function fecha(Request $request, $id)
    {
        $fechaInicio = $request->input('fecha_inicio');
        $fechaFin = $request->input('fecha_fin');
        

        return Excel::download(new EncuestaPeriodoExport($id, $fechaInicio, $fechaFin), "Encuesta_{$id}_{$fechaInicio}_al_{$fechaFin}.xlsx");
    }

}
