<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Encuesta;
use App\Models\Pregunta;
use App\Models\Respuesta;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\EncuestaExport;


 

class exportController extends Controller
{
    public function index()
    {
        $id = 42;
        // Buscar la encuesta por ID
        $encuesta = Encuesta::select('titulo', 'descripcion', 'frecuencia', 'categoria')
                            ->where('id', $id)
                            ->first();

        // Verificar si existe
        if (!$encuesta) {
            return redirect()->back()->with('error', 'Encuesta no encontrada');
        }
        
        $preguntas = Pregunta::where('encuesta_id', $id)->get();

        // Obtener respuestas agrupadas por usuario
        $respuestas = Respuesta::where('encuesta_id', $id)
                    ->with(['preguntas', 'usuario'])
                    ->orderBy('created_at')
                    ->get()
                    ->groupBy(function ($respuesta) {
                        // Agrupa por user_id y fecha exacta del intento
                        return $respuesta->user_id . '|' . $respuesta->created_at->format('YmdHis');
                    });

        return view('hse.exportEncuesta', compact('encuesta', 'preguntas', 'respuestas'));

        //return view('hse.exportEncuesta', compact('encuesta')); // Asegúrate de tener resources/views/export.blade.php
    }
    public function export(Request $request)
    {
        // Obtiene la fecha seleccionada desde el formulario de la vista
        //$fechaSeleccionada = $request->input('fechaReporte');

        // Utiliza la clase ProdExport para generar y descargar el archivo Excel con los reportes de la fecha seleccionada
        return Excel::download(new EncuestaExport(), 'Encuesta.xlsx');
    }
    
}
