<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\reportTimeModel; // Modelo que gestiona los registros de tiempo de los reportes
use App\Models\User; // Modelo que gestiona los usuarios
use Illuminate\Support\Facades\Auth; // Proporciona funcionalidad de autenticación
use Carbon\Carbon; // Biblioteca para manejo de fechas y tiempo

class tareaController extends Controller
{
    //
    public function index(request $request)
    {
        $UserId = Auth::user()->identification;

        $filterDate = $request->input('filterDate');
        $year = date('Y', strtotime($filterDate)); // Extraer el año
        $month = date('m', strtotime($filterDate)); // Extraer el mes

        $reportes = reportTimeModel::where('identification', $UserId)
            ->whereYear('date', $year)
            ->whereMonth('date', $month)
            ->orderBy('date')
            ->get();

        return view('tareasHistorial', compact('reportes'));
    }

    public function historyedith($id)
    {
        // Busca el reporte por su ID y lo retorna como JSON
        $report = reportTimeModel::findOrFail($id);
        return response()->json($report);
    }

    public function historyact(Request $request, $id)
    {
        $request->validate([
            'fecha' => 'required|date',
            'descripcion' => 'required|string',
        ]);

        $report = reportTimeModel::findOrFail($id);

        $report->update([
            'date' => $request->fecha,
            'description' => $request->descripcion,
        ]);

        return response()->json(['success' => 'Actualizacion de datos registrada exitosamente']);
    }

    public function delle(Request $request, $id)
    {
        $report = reportTimeModel::findOrFail($id);
        if ($report) {

            $report->delete();
            // Retorna una respuesta en JSON indicando el éxito de la operación
            return response()->json(['success' => 'Reporte eliminado con éxito']);
        }

        // Si el usuario no se encuentra, retorna un error 404
        return response()->json(['error' => 'Reporte no encontrado'], 404);
    }
}
