<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectIfSessionExpired
{
    public function handle($request, Closure $next)
    {
        if (Auth::check() && !Auth::user()) {
            Auth::logout();
            return redirect()->route('login')->with('message', 'Your session has expired. Please log in again.');
        }

        return $next($request);
    }
}
