<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Address;

class RecepcionMailable extends Mailable
{
    use Queueable, SerializesModels;

    public $nombreRemi;
    public $nombreDesti;
    public $titulo;
    public $errores;
    public $observaciones;
    public $linkProducto;

    /**
     * Create a new message instance.
     */
    public function __construct($nombreRemi, $nombreDesti, $titulo, $errores, $observaciones, $linkProducto)
    {
        $this->nombreRemi = $nombreRemi;
        $this->nombreDesti = $nombreDesti;
        $this->titulo = $titulo;
        $this->errores = $errores;
        $this->observaciones = $observaciones;
        $this->linkProducto = $linkProducto;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            // direccion de correo electronido del remitente
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.recepcion',
            with: [
                'remitente' => $this->nombreRemi,
                'minombre' => $this->nombreDesti,
                'titulo' => $this->titulo,
                'errores' => $this->errores,
                'observaciones' => $this->observaciones,
                'link' => $this->linkProducto,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
