<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Address;

class RevisionMailable extends Mailable
{
    use Queueable, SerializesModels;

    public $remitente;
    public $destinatario;
    public $titulo;
    public $descripcion;
    public $link;

    /**
     * Create a new message instance.
     */
    public function __construct($remitente, $destinatario, $titulo, $descripcion, $link)
    {
        $this->remitente = $remitente;
        $this->destinatario = $destinatario;
        $this->titulo = $titulo;
        $this->descripcion = $descripcion;
        $this->link = $link;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            // direccion de correo electronido del remitente
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.revision',
            with: [
                'titulo' => $this->titulo,
                'descripcion' => $this->descripcion,
                'link' => $this->link,
                'remitente' => $this->remitente,
                'destinatario' => $this->destinatario,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
