<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'sector',
        'product',
        'category',
    ];

    public function scopeProdu($query, $BuscarPerfil = '')
    {
        return $query->where(function ($query) use ($BuscarPerfil) {
            $query->where('sector', 'like', "%$BuscarPerfil%")
                ->orWhere('product', 'like', "%$BuscarPerfil%");
        });
    }
}
