<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Encuesta extends Model
{
    use HasFactory;

    protected $table = 'encuestas';

    protected $fillable = [
        'titulo',
        'descripcion',
        'frecuencia',
        'url',
        'categoria',
        'activa',
        'creada_por',
    ];

    public function usuarios()
    {
        return $this->belongsTo(Pregunta::class);
    }

    public function preguntas()
    {
        return $this->hasMany(Pregunta::class);
    }

    public function scopeEncuesta($query, $EncuestaBus = '')
    {
        return $query->where('titulo', 'like', "%$EncuestaBus%");
    }
    
    /* public function scopeEncuesta($query, $EncuestaBus = '')
    {
        return $query->where(function ($query) use ($EncuestaBus) {
            $query->where('titulo', 'like', "%$EncuestaBus%");   
        });
    } */
}
