<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pregunta extends Model
{
    //
    use HasFactory;

    protected $table = 'preguntas';

    protected $fillable = [
        'encuesta_id',
        'texto',
        'tipo',
        'orden',
        'valor',
    ];

    public function encuesta()
    {
        return $this->belongsTo(Encuesta::class);
    }

    public function opciones()
    {
        return $this->hasMany(Opcion::class);
    }
}
