<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Respuesta extends Model
{
    //
    use HasFactory;

    protected $table = 'respuestas';

    protected $fillable = [
        'pregunta_id',
        'encuesta_id',
        'user_id',
        'url',
        'valor',
        'puntaje',
        'respuesta_meta_id',
        'opcion_id',
        'respuesta_texto',
    ];

    public function preguntas()
    {
        return $this->belongsTo(Pregunta::class);
    }

    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    
    public function meta()
    {
        return $this->belongsTo(RespuestaMeta::class, 'respuesta_meta_id');
    }
}
