<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Revision extends Model
{
    protected $table = 'revision';

    protected $fillable = [
        'remitente',
        'destinatario',
        'titulo',
        'fecha_envio',
        'fecha_respuesta',
        'n_errores',
        'observaciones',
        'link',
    ];

    public function destinatarioUser()
    {
        return $this->belongsTo(User::class, 'destinatario', 'identification');
    }
    public function remitenteUser()
    {
        return $this->belongsTo(User::class, 'remitente', 'identification');
    }
}
