<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'identification',
        'name',
        'email',
        'phone',
        'ods',
        'rol',
        'charge',
        'password',
        'state',
        'location',
        'emailecp',
        'activo',
        'vicepresidencia',
        'gerencia',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function encuestas()
    {
        return $this->hasMany(Encuesta::class);
    }

    public function charges()
    {
        return $this->belongsTo(Charge::class, 'charge', 'charge');
    }

    public function scopeUsuar($query, $UsuarioBus = '')
    {
        return $query->where(function ($query) use ($UsuarioBus) {
            $query->where('identification', 'like', "%$UsuarioBus%")
                ->orWhere('name', 'like', "%$UsuarioBus%")
                ->orWhere('email', 'like', "%$UsuarioBus%");
        });
    }
}
