<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class New_fn extends Model
{
    use HasFactory;

    protected $table = 'new_fn';

    protected $fillable = [

        'fn',
        'identification',
        'service',
    ];

    public function scopeSearch($query, $scope = '')
    {
        return $query->where(function ($query) use ($scope) {
            $query->where('users.name', 'like', "%$scope%")
                ->orWhere('new_fn.fn', 'like', "%$scope%")
                ->orWhere('new_fn.service', 'like', "%$scope%");
        });
    }
}
