<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'charge',
        'professional',
        'product',
        'description',
        'category',
        'date',
        // 'month',
        'fn',
        'code_sig',
        'service',
        'location',
        'activo',
        'link',
        'state',

        'id_gestion_predial_del_pms',
        'tipo_de_hito_clave_de_control',
        'hito_clave_de_control_solicitud_servicio',
        'servicios_participan_elaboracion_del_hito',
        'ruta_url',

        'hito_clave_de_control_no_planeado_directriz',
        'valoracion_de_resultado',
        'justificacion_del_impacto_alto',
        'funcionario_solicitante_no_planeado',
        'horas_acumuladas_al_cumplimiento_hito',

    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'professional', 'identification');
    }
}
