<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('charges', function (Blueprint $table) {
            $table->id();
            $table->string('charge')->unique();
            $table->timestamps();
        });

        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->integer('identification')->unique();
            $table->string('name');
            $table->string('email')->unique();
            $table->bigInteger('phone')->nullable();
            $table->text('ods')->nullable();
            $table->string('rol');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('charge');
            $table->string('state');
            $table->string('activo')->nullable();
            $table->string('vicepresidencia')->nullable();
            $table->string('gerencia')->nullable();
            $table->string('location');
            $table->string('emailecp', 150)->nullable();
            $table->rememberToken();
            $table->timestamps();

            // Definir las claves foráneas
            $table->foreign('charge')->references('charge')->on('charges');
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('charges');
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
