<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use League\CommonMark\Reference\Reference;

return new class extends Migration
{
    /**
     * Run the migrations.
     * @return void
     */
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id('id');
            $table->string('sector', 255);
            $table->string('product', 255);
            $table->string('category');
            $table->timestamps();
        });

        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255)->unique();
            $table->timestamps();
        });

        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->string('charge');
            $table->integer('professional');
            $table->string('product', 255);
            $table->text('description');
            $table->string('category');
            $table->date('date');
            $table->string('fn');
            $table->string('code_sig');
            $table->string('service', 255);
            $table->string('location');
            $table->string('activo');
            $table->string('link', 510)->nullable();
            $table->string('state');

            $table->timestamps();

            // Definir las claves foráneas
            $table->foreign('professional')->references('identification')->on('users');
            // $table->foreign('product')->references('product')->on('categories');
            // $table->foreign('service')->references('name')->on('services'); //se comento linea de codigo, para permitir registrar servicio diferente para los de invaciones.
        });
    }

    /**
     * Reverse the migrations.
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
        Schema::dropIfExists('services');
        Schema::dropIfExists('categories');
    }
};
