<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('timereport', function (Blueprint $table) {
            $table->id();
            $table->integer('identification');
            // $table->text('ods')->nullable();
            $table->date('date');
            $table->string('location');
            $table->text('description')->nullable();
            $table->integer('id_report');
            $table->timestamps();

            // Definir las claves foráneas
            $table->foreign('identification')->references('identification')->on('users');
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('timereport');
    }
};
