<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('new_fn', function (Blueprint $table) {
            $table->id();
            $table->string('fn');
            $table->integer('identification');
            $table->string('service');

            $table->foreign('identification')->references('identification')->on('users');
            $table->foreign('service')->references('name')->on('services');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fn');
    }
};
