<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('revision', function (Blueprint $table) {
            $table->id();
            $table->integer('remitente');
            $table->integer('destinatario');
            $table->string('titulo');
            $table->date('fecha_envio');
            $table->date('fecha_respuesta')->nullable();
            $table->integer('n_errores')->nullable();
            $table->text('observaciones')->nullable();
            $table->string('link', 510);
            $table->timestamps();

            // Definir las claves foráneas
            $table->foreign('remitente')->references('identification')->on('users');
            $table->foreign('destinatario')->references('identification')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('revision');
    }
};
