<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->string('aliado')->default('Ingicat SAS')->after('state');
            $table->string('id_gestion_predial_del_pms', 150)->nullable()->after('aliado');
            $table->string('tipo_de_hito_clave_de_control')->nullable()->after('id_gestion_predial_del_pms');
            $table->string('hito_clave_de_control_no_planeado_directriz')->nullable()->after('tipo_de_hito_clave_de_control');
            $table->string('valoracion_de_resultado')->nullable()->after('hito_clave_de_control_no_planeado_directriz');
            $table->text('justificacion_del_impacto_alto')->nullable()->after('valoracion_de_resultado');
            $table->string('funcionario_solicitante_no_planeado')->nullable()->after('justificacion_del_impacto_alto');
            $table->string('horas_acumuladas_al_cumplimiento_hito')->nullable()->after('funcionario_solicitante_no_planeado');
            $table->string('hito_clave_de_control_solicitud_servicio')->nullable()->after('horas_acumuladas_al_cumplimiento_hito');
            $table->text('servicios_participan_elaboracion_del_hito')->nullable()->after('hito_clave_de_control_solicitud_servicio');
            $table->text('ruta_url', 510)->nullable()->after('servicios_participan_elaboracion_del_hito');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropColumn([
                'aliado',
                'id_gestion_predial_del_pms',
                'tipo_de_hito_clave_de_control',
                'hito_clave_de_control_no_planeado_directriz',
                'valoracion_de_resultado',
                'justificacion_del_impacto_alto',
                'funcionario_solicitante_no_planeado',
                'horas_acumuladas_al_cumplimiento_hito',
                'hito_clave_de_control_solicitud_servicio',
                'servicios_participan_elaboracion_del_hito',
                'ruta_url',
            ]);
        });
    }
};
