//llamamos el csrf del archivo blede, donde esta el contenido que muestra la tabla de usuarios.
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

//mensaje de aprobador registrado con exito
$(document).ready(function () {
    $('#aprobado').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/registros/nuevo',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function () {
                Swal.fire({
                    title: 'Error',
                    html: "Dato ya registrado",
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

});

// Función para eliminar un aprobador
function deleteApprover(approverId) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/registros/${approverId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El Aprobador ha sido eliminado.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            'Error al eliminar el aprobador',
                            'error'
                        );
                    }
                });
        }
    });
}

$(document).on('click', '.pagination a', function (e) {
    e.preventDefault();
    var page = $(this).attr('href').split('page=')[1];

    $.ajax({
        url: '/registros?page=' + page,
        type: 'GET',
        dataType: 'html',
        success: function (data) {
            $('#divTable').html(data);
        }
    });
});