//llamamos el csrf del archivo blede, donde esta el contenido que muestra la tabla de usuarios.
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

//mensaje de asignación registrada, de forma manual, oseqa uno por uno.
$(document).ready(function () {
    $('#asignaFn').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/registros/new',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function () {
                Swal.fire({
                    title: 'Error',
                    html: "Dato ya registrado",
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

});

//mensaje de importación exitosa, archivo csv, en utf8 delimitado por comas.
$(document).ready(function () {
    $('#mensajeFn').on('submit', function (e) {
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: '/import-fn',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function () {
                Swal.fire({
                    title: 'Error',
                    html: "El dato ya se encuentra registrado o algun usuario no esta registrado",
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

});

// Función para eliminar un Fn asignado
function deleteFnAsignado(identification, fn) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/registro/${identification}/${fn}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El Fn asignado ha sido eliminado.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            'Error al eliminar el Fn asignado',
                            'error'
                        );
                    }
                });
        }
    });
}

$(document).ready(function () {
    // Función para cargar datos con AJAX
    function fetch_data(page, scope) {
        $.ajax({
            url: "/asignacion-fn?page=" + page + "&scope=" + scope,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $("#divTable").html(data);
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", error);
            }
        });
    }

    // Evento keyup para búsqueda en tiempo real
    $(document).on("keyup", "#scope", function () {
        var scope = $(this).val();
        fetch_data(1, scope); // Siempre empieza desde la página 1 al buscar
    });

    // Evento click para paginación
    $(document).on("click", ".pagination a", function (e) {
        e.preventDefault();
        var page = $(this).attr("href").split("page=")[1];
        var scope = $("#scope").val();
        fetch_data(page, scope);
    });
});


// $(document).on('click', '.pagination a', function (e) {
//     e.preventDefault();
//     var page = $(this).attr('href').split('page=')[1];

//     $.ajax({
//         url: '/asignacion-fn?page=' + page,
//         type: 'GET',
//         dataType: 'html',
//         success: function (data) {
//             $('#divTable').html(data);
//         }
//     });
// });

// //buscador
// $(document).on('keyup', '#scope', function () {
//     var scope = $(this).val();

//     $.ajax({
//         url: '/asignacion-fn',
//         type: 'GET',
//         data: {
//             scope: scope
//         },
//         dataType: 'html',
//         success: function (data) {
//             $('#divTable').html(data);
//         }
//     });
// });

// $(document).on('click', '.pagination a', function (e) {
//     e.preventDefault();
//     $.ajax({
//         url: '/asignacion-fn',
//         data: { page: $(this).attr('href').split('page=')[1] },
//         type: 'GET',
//         dataType: 'json',
//         success: function (result) {
//             $("#divTable").html(result);
//         }
//     });
// });
