//mensaje de fn y codigo sig registrada, de forma manual, oseqa uno por uno.
$(document).ready(function () {
    $('#Fnsubido').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/fn-sig/registro',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function (xhr) {
                let message = xhr.responseJSON.message || 'Ocurrió un error.';
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: message,
                });
            }
        });
    });

});

//mensaje de importación de fn y codigo sig
$(document).ready(function () {
    $('#mensajeSig').on('submit', function (e) {
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: '/fn-sig/import',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function (xhr) {
                let message = xhr.responseJSON.message || 'Ocurrió un error.';
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: message,
                });
            }
        });
    });

});

$(document).ready(function () {
    // Función para cargar datos con AJAX
    function fetch_data(page, FnBuscar) {
        $.ajax({
            url: "/fn-sig?page=" + page + "&FnBuscar=" + FnBuscar,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $("#divTablefn").html(data);
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", error);
            }
        });
    }

    // Evento keyup para búsqueda en tiempo real
    $(document).on("keyup", "#FnBuscar", function () {
        var FnBuscar = $(this).val();
        fetch_data(1, FnBuscar); // Siempre empieza desde la página 1 al buscar
    });

    // Evento click para paginación
    $(document).on("click", ".pagination a", function (e) {
        e.preventDefault();
        var page = $(this).attr("href").split("page=")[1];
        var FnBuscar = $("#FnBuscar").val();
        fetch_data(page, FnBuscar);
    });
});

//llamamos el csrf del archivo blade, donde esta el contenido que muestra la tabla de fn y codigo sig.
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

// Función para eliminar un Fn asignado
function deleteSig(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/fn-sigs/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El Fn y Codigo SIG ha sido eliminado.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            'Error al eliminar el Fn y Codigo SIG',
                            'error'
                        );
                    }
                });
        }
    });
}
