$(document).ready(function () {
    $('#registroform').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/gestion-usuario/nuevo',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function () {
                Swal.fire({
                    title: 'Error',
                    html: "Dato ya registrado",
                    icon: 'error',
                    confirmButtonText: 'OK'
                });
            }
        });
    });

});

//llamamos el csrf del archivo blede, donde esta el contenido que muestra la tabla de usuarios.
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

// Función para eliminar un usuario
function deleteUser(userId) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/usuario/${userId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El usuario ha sido eliminado.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            'Error al eliminar el usuario',
                            'error'
                        );
                    }
                });
        }
    });
}


//mensaje de alerta, de envio del formulario de acxtualización de los datos.

// Función para manejar el envío del formulario de edición
$('#editForm').on('submit', function (e) {
    e.preventDefault();
    const form = $(this);
    const url = form.attr('action');

    $.ajax({
        type: 'PUT',
        url: url,
        data: form.serialize(),
        success: function (response) {
            $('#editModal').addClass('hidden');
            Swal.fire({
                title: 'Actualización exitosa',
                text: response.success,
                icon: 'success',
                confirmButtonText: 'OK'
            }).then(() => {
                location.reload();
            });
        },
        error: function (xhr) {
            let errorMessage = 'Algo salió mal';
            if (xhr.responseJSON && xhr.responseJSON.errors) {
                errorMessage = Object.values(xhr.responseJSON.errors).join('<br>');
            }
            Swal.fire({
                title: 'Error',
                html: errorMessage,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
    });
});

$(document).ready(function () {
    // Función para cargar datos con AJAX
    function fetch_data(page, UsuarioBus) {
        $.ajax({
            url: "/gestion-usuario/lista?page=" + page + "&UsuarioBus=" + UsuarioBus,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $("#divTableUser").html(data);
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", error);
            }
        });
    }

    // Evento keyup para búsqueda en tiempo real
    $(document).on("keyup", "#UsuarioBus", function () {
        var UsuarioBus = $(this).val();
        fetch_data(1, UsuarioBus); // Siempre empieza desde la página 1 al buscar
    });

    // Evento click para paginación
    $(document).on("click", ".pagination a", function (e) {
        e.preventDefault();
        var page = $(this).attr("href").split("page=")[1];
        var UsuarioBus = $("#UsuarioBus").val();
        fetch_data(page, UsuarioBus);
    });
});
