//llamamos el csrf del archivo blede, donde esta el contenido que muestra la tabla de usuarios.
const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

$(document).ready(function () {
    $('#productoForm').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/agregar-producto/registro',
            type: 'POST',
            data: $(this).serialize(),
            success: function (response) {

                //mostrar la alerta de registrado correctamente.
                Swal.fire({
                    title: "¡Buen Trabajo!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos antes de recargar la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function (xhr) {
                let message = xhr.responseJSON.message || 'Ocurrió un error.';
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: message,
                });
            }
        });
    });

});

function deleteProduc(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: "¡No podrás revertir esto!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, eliminarlo!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/agregar-producto/registro/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El producto ha sido eliminado.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire(
                            'Error',
                            'Error al eliminar el producto',
                            'error'
                        );
                    }
                });
        }
    });
}

$(document).ready(function () {
    // Función para cargar datos con AJAX
    function fetch_data(page, BuscarPerfil) {
        $.ajax({
            url: "/agregar-producto?page=" + page + "&BuscarPerfil=" + BuscarPerfil,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $("#productoTable").html(data);
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", error);
            }
        });
    }

    // Evento keyup para búsqueda en tiempo real
    $(document).on("keyup", "#BuscarPerfil", function () {
        var BuscarPerfil = $(this).val();
        fetch_data(1, BuscarPerfil); // Siempre empieza desde la página 1 al buscar
    });

    // Evento click para paginación
    $(document).on("click", ".pagination a", function (e) {
        e.preventDefault();
        var page = $(this).attr("href").split("page=")[1];
        var BuscarPerfil = $("#BuscarPerfil").val();
        fetch_data(page, BuscarPerfil);
    });
});
