$(document).on('click', '.pagination a', function (e) {
    e.preventDefault();
    var page = $(this).attr('href').split('page=')[1];

    $.ajax({
        url: '/recepcion?page=' + page,
        type: 'GET',
        dataType: 'html',
        success: function (data) {
            $('#TablaRecepcion').html(data);
        }
    });
});

$(document).on('click', '.recepcion-btn', function () {

    const id = $(this).data('id');
    $('#recepcionForm').attr('action', `/recepcion/${id}`);

    // Mostrar el modal
    $('#respuestaModal').removeClass('hidden');

});

// Función para cerrar el modal de edición
$(document).on('click', '[data-modal-hide]', function () {
    $('#respuestaModal').addClass('hidden');
});

// Función para manejar el envío del formulario de edición
$('#recepcionForm').on('submit', function (e) {
    e.preventDefault();
    const form = $(this);
    const url = form.attr('action');

    $.ajax({
        type: 'PUT',
        url: url,
        data: form.serialize(),
        success: function (response) {
            $('#respuestaModal').addClass('hidden');
            Swal.fire({
                title: 'Respuesta realizada',
                text: response.success,
                icon: 'success',
                confirmButtonText: 'OK'
            }).then(() => {
                location.reload();
            });
        },
        error: function (xhr) {
            let errorMessage = 'Algo salió mal';
            if (xhr.responseJSON && xhr.responseJSON.errors) {
                errorMessage = Object.values(xhr.responseJSON.errors).join('<br>');
            }
            Swal.fire({
                title: 'Error',
                html: errorMessage,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
    });
});
