// Limite de escritura en los campos de Fn y Codigo SIG, en el formulario de reporte.
const codigoSig = document.querySelector('#codigo');

// Nuevo límite de caracteres
const limiteCaracteres = 8;

// Función para manejar la limitación de caracteres
// function limitarCaracteres(campo, limite) {
//     campo.addEventListener('input', e => {
//         if (campo.value.length > limite) {
//             alert(`Máximo ${limite} caracteres.`);
//             campo.value = campo.value.substring(0, limite);
//         }
//     });

//     // Volver a "No Aplica" si el campo queda vacío al perder el foco
//     campo.addEventListener('blur', e => {
//         if (campo.value.trim() === "") {
//             campo.value = "No Aplica";
//         }
//     });
// }

// Inicializar campos con "No Aplica"
// codigoSig.value = "No Aplica";

// Manejar el evento blur en codigoSig para establecer "No Aplica" si queda vacío
// codigoSig.addEventListener('blur', e => {
//     if (codigoSig.value.trim() === "") {
//         codigoSig.value = "No Aplica";
//     }
// });

// Colocar "No Aplica" si los campos están vacíos al enviar el formulario
// document.getElementById('registro-form').addEventListener('submit', function (e) {

//     if (codigoSig.value.trim() === "") {
//         codigoSig.value = "No Aplica";
//     }
// });

//envio de datos, formulario de reporte.

$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$(document).ready(function () {
    $('#sector').change(function () {
        var sector = $(this).val();
        if (sector) {
            $.ajax({
                url: '/reporte-producto/productos',
                type: 'POST',
                data: {
                    sector: sector
                },
                success: function (data) {
                    var productoSelect = $('#producto');
                    productoSelect.empty();
                    productoSelect.append('<option value="">Seleccionar</option>');
                    data.forEach(function (producto) {
                        productoSelect.append('<option value="' + producto.product + '">' + producto.product + '</option>');
                    });
                    productoSelect.append('<option value="Otro">Otro...</option>');
                },
                error: function () {
                    alert('Error al cargar los productos');
                }
            });
        } else {
            $('#producto').empty();
            $('#producto').append('<option value="">Seleccionar</option>');
            // $('#producto').append('<option value="Otro">Otro...</option>');
            $('#category').text('');
            $('#categoria').val('');
        }
    });

    $('#producto').change(function () {
        var producto = $(this).val();
        if (producto) {
            $.ajax({
                url: '/reporte-producto/categoria',
                type: 'POST',
                data: {
                    producto: producto
                },
                success: function (data) {
                    $('#category').text(data.category); // muestra la categoria
                    $('#categoria').val(data
                        .category); // asigna la categoria a la variable
                },
                error: function () {
                    $('#category').text('Error al cargar la categoría');
                }
            });
        } else {
            $('#category').text('');
            $('#categoria').val('');
        }
    });

    $('#fn').change(function () {
        var fn = $(this).val();
        var fnSelect = $('#servicio');
        var sigSelect = $('#codigo');
        fnSelect.empty();
        sigSelect.empty();
        if (fn == "No Aplica" || fn == "Directriz") {
            fnSelect.append('<option value="No Aplica">No Aplica</option>');
            sigSelect.append('<option value="No Aplica">No Aplica</option>');
        } else if (fn) {
            $.ajax({
                url: '/reporte-producto/servicio',
                type: 'POST',
                data: {
                    fn: fn
                },
                success: function (data) {
                    if (data) {
                        if (data.service) {
                            fnSelect.append('<option value="' + data.service + '">' + data.service + '</option>')
                        } else {
                            fnSelect.append('<option value="">No hay servicio disponible</option>');
                        }

                        sigSelect.empty();
                        if (data.codigo_sig.length) {
                            data.codigo_sig.forEach(function (codigo) {
                                sigSelect.append('<option value="' + codigo + '">' + codigo + '</option>');
                            });
                        } else {
                            sigSelect.append('<option value="">No hay codigo sig disponible</option>');
                        }
                    }
                },
                error: function () {
                    $('#servicio').empty();
                    $('#codigo').empty();
                    $('#servicio').append('<option value="">Seleccionar</option>');
                    $('#codigo').append('<option value="">Seleccionar</option>');
                }
            });
        } else {
            fnSelect.append('<option value="">Seleccionar</option>');
            sigSelect.append('<option value="">Seleccionar</option>');
        }
    });

    $('#submit-btn').click(function (e) {
        // Validar campos requeridos manualmente
        let isValid = true;
        $('#registro-form [required]').each(function () {
            if ($(this).val().trim() === '') {
                isValid = false;
                $(this).addClass('border-red-500'); // Resaltar el campo vacío
            } else {
                $(this).removeClass('border-red-500'); // Quitar resaltado si está completo
            }
        });

        if (!isValid) {
            return; // Detener si hay campos incompletos
        }

        e.preventDefault();

        var producto = $('#producto').val();

        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡No podrás revertir esto!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, enviar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // url: $('#registro-form').attr('action'),
                let url = (producto === 'Otro') ? '/tiempo/store' : '/reporte/store';
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: $('#registro-form').serialize(),
                    success: function (response) {
                        Swal.fire(
                            'Enviado',
                            'Su tarea se ha registrado correctamente.',
                            'success'
                        ).then(() => {
                            location.reload();
                        });
                    },
                    error: function (response) {
                        Swal.fire(
                            'Error',
                            'Hubo un problema al registrar la actividad.',
                            'error'
                        );
                    }
                });
            }
        });
    });

});


// Función para manejar el envío del formulario de edición
$('#editForm').on('submit', function (e) {
    e.preventDefault();
    const form = $(this);
    const url = form.attr('action');

    $.ajax({
        type: 'PUT',
        url: url,
        data: form.serialize(),
        success: function (response) {
            $('#editModal').addClass('hidden');
            Swal.fire({
                title: 'Producto finalizado',
                text: response.success,
                icon: 'success',
                confirmButtonText: 'OK'
            }).then(() => {
                location.reload();
            });
        },
        error: function (xhr) {
            let errorMessage = 'Algo salió mal';
            if (xhr.responseJSON && xhr.responseJSON.errors) {
                errorMessage = Object.values(xhr.responseJSON.errors).join('<br>');
            }
            Swal.fire({
                title: 'Error',
                html: errorMessage,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
    });
});

document.getElementById('producto').addEventListener('change', function () {
    if (this.value === 'Otro') {
        document.getElementById('modalOtroProducto').classList.remove('hidden');
    }
});


document.getElementById('cancelarModal').addEventListener('click', function () {
    document.getElementById('modalOtroProducto').classList.add('hidden');
    document.getElementById('producto').value = '';
    document.getElementById('category').innerText = '';
    document.getElementById('category').value = '';
});





document.getElementById('guardarProducto').addEventListener('click', function () {
    const nuevoProducto = document.getElementById('nuevoProducto').value;
    const nuevaCategoria = document.getElementById('nuevaCategoria').value;

    if (nuevoProducto && nuevaCategoria) {

        const productoSelect = document.getElementById('producto');
        const nuevaOpcion = new Option(nuevoProducto, nuevoProducto);
        productoSelect.add(nuevaOpcion, productoSelect.options[productoSelect.selectedIndex]);
        productoSelect.value = nuevoProducto;

        // Actualizar la descripción con el nuevo producto
        // document.getElementById('descripcion').innerText = nuevoProducto;
        // document.getElementById('descripcion').value = nuevoProducto;

        // Actualizar la categoría
        document.getElementById('category').innerText = nuevaCategoria;
        document.getElementById('categoria').value = nuevaCategoria;

        // Cerrar el modal
        document.getElementById('modalOtroProducto').classList.add('hidden');
    } else {
        alert('Por favor, complete ambos campos.');
    }
});

document.getElementById('fn').addEventListener('change', function () {
    if (this.value === 'Otro') {
        document.getElementById('modalOtroFns').classList.remove('hidden');
    }
});

document.getElementById('CancelarModalFn').addEventListener('click', function () {
    document.getElementById('modalOtroFns').classList.add('hidden');
});




document.getElementById('GuardarNuevoFn').addEventListener('click', function () {
    const nuevoFns = document.getElementById('nuevoFns').value;
    const nuevoServicio = document.getElementById('nuevoServicio').value;
    const nuevoSig = document.getElementById('nuevoSIG').value;

    if (nuevoFns && nuevoServicio && nuevoSig) {

        const FnsSelect = document.getElementById('fn');
        const nuevaOpcion = new Option(nuevoFns, nuevoFns);
        FnsSelect.add(nuevaOpcion, FnsSelect.options[FnsSelect.selectedIndex]);
        FnsSelect.value = nuevoFns;

        const SigSelect = document.getElementById('codigo');
        const nuevaOpcionSig = new Option(nuevoSig, nuevoSig);
        SigSelect.add(nuevaOpcionSig, SigSelect.options[SigSelect.selectedIndex]);
        SigSelect.value = nuevoSig;


        // Asignar servicio a fn seleccionada
        const ServicioSelect = document.getElementById('servicio');
        const nuevaOpcionServicio = new Option(nuevoServicio, nuevoServicio);
        ServicioSelect.add(nuevaOpcionServicio, ServicioSelect.options[ServicioSelect.selectedIndex]);
        ServicioSelect.value = nuevoServicio;

        // Cerrar el modal
        document.getElementById('modalOtroFns').classList.add('hidden');
    } else {
        alert('Por favor, complete ambos campos.');
    }
});
document.getElementById('fn').addEventListener('change', function (){
    if (this.value === 'Invasiones'){
        document.getElementById('modalInvasiones').classList.remove('hidden');
    }
});

document.getElementById('CancelInvasiones').addEventListener('click', function () {
    document.getElementById('modalInvasiones').classList.add('hidden');
});

document.getElementById('GuardarInvasiones').addEventListener('click', function () {
    const nuevoFns = document.getElementById('FNinvasion').value;
    const nuevoServicio = document.getElementById('predio').value;
    const nuevoSig = document.getElementById('SIGinva').value;

    if (nuevoFns && nuevoServicio && nuevoSig) {

        const FnsSelect = document.getElementById('fn');
        const nuevaOpcion = new Option(nuevoFns, nuevoFns);
        FnsSelect.add(nuevaOpcion, FnsSelect.options[FnsSelect.selectedIndex]);
        FnsSelect.value = nuevoFns;

        const SigSelect = document.getElementById('codigo');
        const nuevaOpcionSig = new Option(nuevoSig, nuevoSig);
        SigSelect.add(nuevaOpcionSig, SigSelect.options[SigSelect.selectedIndex]);
        SigSelect.value = nuevoSig;


        // Asignar servicio a fn seleccionada
        const ServicioSelect = document.getElementById('servicio');
        const nuevaOpcionServicio = new Option(nuevoServicio, nuevoServicio);
        ServicioSelect.add(nuevaOpcionServicio, ServicioSelect.options[ServicioSelect.selectedIndex]);
        ServicioSelect.value = nuevoServicio;

        // Cerrar el modal
        document.getElementById('modalInvasiones').classList.add('hidden');
    } else {
        alert('Por favor, complete ambos campos.');
    }
});
