const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

// filtro de busqueda y paginacion.
$(document).ready(function () {
    // Función para cargar datos con AJAX
    function fetch_data(page, UsuarioBus) {
        $.ajax({
            url: "/usuario?page=" + page + "&UsuarioBus=" + UsuarioBus,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $("#TableUsers").html(data);
            },
            error: function (xhr, status, error) {
                console.error("Error en la solicitud AJAX:", error);
            }
        });
    }

    // Evento keyup para búsqueda en tiempo real
    $(document).on("keyup", "#UsuarioBus", function () {
        var UsuarioBus = $(this).val();
        fetch_data(1, UsuarioBus); // Siempre empieza desde la página 1 al buscar
    });

    // Evento click para paginación
    $(document).on("click", ".pagination a", function (e) {
        e.preventDefault();
        var page = $(this).attr("href").split("page=")[1];
        var UsuarioBus = $("#UsuarioBus").val();
        fetch_data(page, UsuarioBus);
    });
});

// mostrar modal de agregar usuario
document.addEventListener('DOMContentLoaded', () => {
    const openBtn = document.getElementById('openAddUserModal');
    const closeBtn = document.getElementById('closeAddUserModal');
    const modal = document.getElementById('add-user-modal');
    const importModal = document.getElementById('importUserModalButton');
    const importModalClose = document.getElementById('closeImportUserModal');
    const modalContent = document.getElementById('importUserModal');

    openBtn.addEventListener('click', () => {
        modal.classList.remove('hidden');
        modal.classList.add('flex'); // o "block" si lo prefieres
        $('body').addClass('modal-open');
    });

    closeBtn.addEventListener('click', () => {
        modal.classList.add('hidden');
        modal.classList.remove('flex'); // o "block"
        $('body').removeClass('modal-open');
    });

    importModal.addEventListener('click', () => {
        modalContent.classList.remove('hidden');
    });

    importModalClose.addEventListener('click', () => {
        modalContent.classList.add('hidden');
    });
});

// registrar usuario
$(document).ready(function () {
    $('#UserForm').on('submit', function (e) {
        e.preventDefault();

        $.ajax({
            url: '/usuario',
            type: 'POST',
            data: $(this).serialize(),
            // headers: {
            //     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            // },
            success: function (response) {

                console.log(response)
                //mostrar alerta con sweetalerts
                Swal.fire({
                    title: "¡Exito!",
                    text: response.success,
                    icon: "success",
                    timer: 3000, //tiempo en milisegundos, que se muestra el mensaje.
                    showConfirmButton: false
                });

                //esperar dos segundos para el recargue de la pagina
                setTimeout(function () {
                    location.reload();
                }, 3000);
            },
            error: function (xhr, status, error) {
                if (xhr.status === 422) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';
                    for (var field in errors) {
                        errorMessage += errors[field].join('<br>'); // Concatenar los errores
                    }

                    Swal.fire({
                        title: 'Error de validación',
                        html: errorMessage,
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                } else {
                    Swal.fire({
                        title: 'Error',
                        html: "Se presentó un problema al registrar el usuario",
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            }

        });
    });

});

// imprimir datos del personal a editar
$(document).on('click', '.edit-btn', function () {
    const id = $(this).data('id');
    const url = `/actualizar/${id}`;

    console.log(url);

    $.get(url, function (data) {
        console.log(data);
        const actionUrl = `/actualizar/${id}`;
        $('#updateUserEdit').attr('action', actionUrl);

        $('#edit_name').val(data.name);
        $('#edit_email').val(data.email);
        $('#edit_emailecp').val(data.emailecp);
        $('#edit_phone').val(data.phone);
        $('#edit_ods').val(data.ods);
        $('#edit_rol option').each(function () {
            if ($(this).val() === data.rol) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });
        $('#edit_charge option').each(function () {
            if ($(this).val() === data.charge_actual) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });
        $('#edit_activo option').each(function () {
            if ($(this).val() === data.activo) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });
        $('#edit_vicepresidencia option').each(function () {
            if ($(this).val() === data.vicepresidencia) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });
        $('#edit_gerencia option').each(function () {
            if ($(this).val() === data.gerencia) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });
        $('#edit_ubicacion option').each(function () {
            if ($(this).val() === data.location) {
                $(this).prop('selected', true);
            } else {
                $(this).prop('selected', false);
            }
        });

        // let chargesOptions = '';

        // data.charges.forEach(charge => {
        //     chargesOptions += `<option value="${charge}" ${charge === data.charge_actual ? 'selected' : ''}>${charge}</option>`;
        // });
        // $('#edit_charge').html(chargesOptions);

        $('#editUsers').removeClass('hidden');
    });
});

// Función para cerrar el modal de edición
$(document).on('click', '[data-modal-edit]', function () {
    $('#editUsers').addClass('hidden');
})

// desactivar usuario
function toggleUserStatus(userId, newState) {
    const accion = newState === 'Activo' ? 'habilitado' : 'inhabilitado';
    const textoExito = `El usuario ha sido ${accion} correctamente.`;

    Swal.fire({
        title: '¿Estás seguro?',
        text: `¿Deseas ${accion} este usuario?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: newState === 'Activo' ? '#28a745' : '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: `Sí, ${accion}`,
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/usuario/${userId}/estado`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ state: newState })
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire('¡Éxito!', textoExito, 'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('Error', data.message || 'No se pudo cambiar el estado.', 'error');
                    }
                })
                .catch(() => {
                    Swal.fire('Error', 'Error del servidor.', 'error');
                });
        }
    });
}

// Actualizar usuario
// $(document).ready(function () {
//     $('#updateUserEdit').on('submit', function (e) {
//         e.preventDefault();

//         const formData = $(this).serialize();
//         const actionUrl = $(this).attr('action');

//         $.ajax({
//             type: 'PUT',
//             url: actionUrl,
//             data: formData,
//             headers: {
//                 'X-CSRF-TOKEN': csrfToken
//             },
//             success: function (response) {
//                 console.log(response);
//                 Swal.fire({
//                     title: "¡Exito!",
//                     text: response.success,
//                     icon: "success",
//                     timer: 3000,
//                     showConfirmButton: false
//                 });

//                 setTimeout(function () {
//                     location.reload();
//                 }, 3000);
//             },
//             error: function (xhr, status, error) {
//                 if (xhr.status === 422) {
//                     var errors = xhr.responseJSON.errors;
//                     var errorMessage = '';
//                     for (var field in errors) {
//                         errorMessage += errors[field].join('<br>');
//                     }

//                     Swal.fire({
//                         title: 'Error de validación',
//                         html: errorMessage,
//                         icon: 'error',
//                         confirmButtonText: 'OK'
//                     });
//                 } else {
//                     Swal.fire({
//                         title: 'Error',
//                         html: "Se presentó un problema al actualizar el usuario",
//                         icon: 'error',
//                         confirmButtonText: 'OK'
//                     });
//                 }
//             }
//         });
//     });
// });
$('#updateUserEdit').on('submit', function (e) {
    e.preventDefault();
    const form = $(this);
    const url = form.attr('action');

    $.ajax({
        type: 'PUT',
        url: url,
        data: form.serialize(),
        success: function (response) {
            console.log(response);
            Swal.fire({
                title: "¡Exito!",
                text: "Usuario actualizado correctamente.",
                icon: "success",
                timer: 3000,  // Tiempo que se muestra el mensaje
                showConfirmButton: false
            });

            setTimeout(function () {
                location.reload();  // Recarga la página después de la actualización
            }, 3000);
        },
        error: function (xhr) {
            let errorMessage = 'Algo salió mal';
            if (xhr.responseJSON && xhr.responseJSON.errors) {
                errorMessage = Object.values(xhr.responseJSON.errors).join('<br>');
            }
            Swal.fire({
                title: 'Error',
                html: errorMessage,
                icon: 'error',
                confirmButtonText: 'OK'
            });
        }
    });
});
