<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Asignación de FN</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-full mx-auto py-10">
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-3 sm:grid-cols-3">
            <div class="sm:col-span-1">
                <form id="productoForm" action="{{ route('agregar.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <h2 class="text-center font-semibold leading-7 text-gray-900">Agregar Producto</h2>

                    <label for="perfil" class="block text-sm font-medium leading-6 text-gray-900">Perfil
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <select id="perfil" name="perfil" required
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 sm:text-sm sm:leading-6">
                            <option value="">Seleccionar</option>
                            @foreach ($perfiles as $perfil)
                                <option value="{{ $perfil->charge }}">{{ $perfil->charge }}</option>
                            @endforeach
                        </select>
                    </div>

                    <label for="producto" class="block text-sm font-medium leading-6 text-gray-900">Producto
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="text" name="producto" id="producto" required
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>



                    <label for="categoria" class="block text-sm font-medium leading-6 text-gray-900">Categoria
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <select id="categoria" name="categoria" required
                            class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 sm:text-sm sm:leading-6">
                            <option value="">Seleccionar</option>
                            <option value="2. Subproducto">Subproducto</option>
                            <option value="3. Producto">Producto</option>
                        </select>
                    </div>

                    <div class="mt-6 flex items-center justify-end ">
                        <button type="submit"
                            class="rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                            Registrar</button>
                    </div>
                </form>

            </div>


            <div class="sm:col-span-2">
                <div class="mt-8 overflow-x-auto">
                    <div class="form-group col-md-5 col-md-offset-7">
                        <input type="text" id="BuscarPerfil" placeholder="Perfil/Producto"
                            class="mt-2 block w-full max-w-xs text-sm text-gray-900 bg-gray-50 rounded-md border border-gray-300 cursor-pointer focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-600 p-2">
                    </div>
                    <h3 class="text-xl font-semibold mb-4">Lista de productos</h3>
                    <div id="productoTable">
                        @include('partials.tableProductos')
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('js/producto.js') }}"></script>
</body>

</html>
