<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Descargar - Reportes producto</title>

</head>

<body>
    @include('layout.header')
    <div class="container w-11/12 mx-auto py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="bg-white shadow-xl rounded-lg p-8">
                <form action="{{ route('masivo.revision') }}" id="reviForm" method="POST">
                    @csrf
                    <h2 class="text-lg font-bold">Descargar revisiones</h2>
                    <div class="grid grid-cols-1 md:grid-cols-1 gap-8">
                        <div class="mt-1">
                            <label for="fecha2" class="block text-sm font-medium text-gray-900">Desde:</label>
                            <input type="date" name="fecha2" id="fecha2" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <label for="fecha3" class="block text-sm font-medium text-gray-900">Hasta:</label>
                            <input type="date" name="fecha3" id="fecha3" required
                                class="mt-1 block w-full p-1 text-lg rounded-md shadow-sm border-2">
                        </div>
                        <div class="m-1">
                            <button
                                class="revi-btn mt-6 rounded-md bg-red-800 px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">Descargar
                                revisiones</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>

</html>
