<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/ingicat.png') }}">
    {{-- @vite('resources/css/app.css') --}}
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>Compartir producto - INGICAT</title>
</head>

<body>
    @include('layout.header')

    <div class="container w-11/12 mx-auto py-12">
        <h2 class="text-center text-base font-semibold leading-7 text-gray-900">ENVIAR</h2>
        <br>
        <div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-3 sm:grid-cols-4">
            <div class="sm:col-span-1">
                <form id="MensajeRevision" action="{{ route('correo.enviar') }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    <label for="titulo" class="block text-sm font-medium leading-6 text-gray-900">Titulo (producto)
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <select id="titulo" name="titulo" required
                            class="block w-full rounded-md border-0 py-1.5 bg-gray-50 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 sm:text-sm sm:leading-6">
                            <option value="">Seleccionar</option>
                            @foreach ($productos as $producto)
                                <option value="{{ $producto->product }}">{{ $producto->product }}</option>
                            @endforeach
                        </select>
                    </div>
                    <br>
                    <label for="descripcion" class="block text-sm font-medium leading-6 text-gray-900">Descripción
                        <strong class=" text-red-600">(Opcional)</strong></label>
                    <div class="mt-2">
                        <textarea id="descripcion" rows="4" name="descripcion"
                            class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500"
                            placeholder="Escribe aqui tu comentario..."></textarea>
                    </div>
                    <br>
                    <label for="link" class="block text-sm font-medium leading-6 text-gray-900">Link
                        <strong class=" text-red-600">*</strong></label>
                    <div class="mt-2">
                        <input type="url" name="link" id="link" required
                            placeholder="ej: https://www.example.com"
                            class="block w-full rounded-md border-0 py-1.5 bg-gray-50 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 sm:text-sm sm:leading-6">
                    </div>

                    <div class="mt-6 flex items-center justify-end ">
                        <button type="submit"
                            class="rounded-md bg-red-800 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-red-700">
                            Enviar</button>
                    </div>
                </form>

            </div>
            <div class="sm:col-span-3">
                <div class="mt-8 overflow-x-auto">
                    <div id="TablaRevision">
                        @include('partials.tableRevision')
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- modal de detalle de respuesta del producto --}}
    <div id="detalleModal" class="fixed inset-0 hidden z-50 overflow-y-auto">
        <div class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm"></div>
        <div class="flex items-center justify-center min-h-screen">
            <div class="relative w-full max-w-lg rounded-lg shadow bg-white">
                <div class="flex items-start justify-between p-4 border-b rounded-t">
                    <h3 class="text-xl font-semibold text-gray-900">Detalle</h3>
                    <button type="button"
                        class="text-black bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center"
                        data-modal-hide="detalleModal">
                        <i class="fa-solid fa-x"></i>
                    </button>
                </div>
                <div class="p-6 space-y-6">
                    <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                        <div>
                            <label for="correo" class="block text-sm font-medium leading-6 text-gray-900">Fecha
                                Respuesta</label>
                            <p id="respuesta-fecha"></p>{{-- nombre de la columna en base de datos es: fecha_respuesta --}}
                        </div>
                        <div>
                            <label for="telefono" class="block text-sm font-medium leading-6 text-gray-900">Link</label>
                            <a id="respuesta-link" href="#" class="text-blue-600 hover:underline"
                                target="_blank">Enlace</a>{{-- nombre de la columna en base de datos es: link --}}
                        </div>
                        <div>
                            <label for="ods"
                                class="block text-sm font-medium leading-6 text-gray-900">Observaciones</label>
                            <p id="respuesta-observaciones"></p>{{-- nombre de la columna en base de datos es: observaciones --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).on('click', '.revision-btn', function() {
            const fechaRespuesta = $(this).data('fecha-respuesta');
            const link = $(this).data('link');
            const observaciones = $(this).data('observaciones');

            // Reemplazar el punto seguido con un salto de línea en HTML
            const observacionesConSaltos = observaciones ? observaciones.replace(/\n/g, '<br>') : 'No disponible';

            // Llenar el modal con los datos
            $('#respuesta-fecha').text(fechaRespuesta || 'No disponible');
            $('#respuesta-link').attr('href', link).text(link ? 'Enlace' : 'No disponible');
            $('#respuesta-observaciones').html(observacionesConSaltos);

            // Mostrar el modal
            $('#detalleModal').removeClass('hidden');

        });

        // Función para cerrar el modal de edición
        $(document).on('click', '[data-modal-hide]', function() {
            $('#detalleModal').addClass('hidden');
        });
    </script>
    <script src="{{ asset('js/revision.js') }}"></script>
</body>

</html>
